"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Fingerprints = void 0;
var _eui = require("@elastic/eui");
var _fp = require("lodash/fp");
var _react = _interopRequireDefault(require("react"));
var _certificate_fingerprint = require("../../certificate_fingerprint");
var _ja3_fingerprint = require("../../ja3_fingerprint");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761322521701505730/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/timelines/components/netflow/fingerprints/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
/**
 * Renders rows of draggable badges containing ja3 and certificate fingerprints
 * (i.e. sha1 hashes)
 */
const Fingerprints = exports.Fingerprints = /*#__PURE__*/_react.default.memo(({
  contextId,
  eventId,
  tlsClientCertificateFingerprintSha1,
  tlsFingerprintsJa3Hash,
  tlsServerCertificateFingerprintSha1,
  scopeId
}) => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
  alignItems: "center",
  "data-test-subj": "fingerprints-group",
  direction: "column",
  justifyContent: "center",
  gutterSize: "none",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 39,
    columnNumber: 5
  }
}, tlsFingerprintsJa3Hash != null ? (0, _fp.uniq)(tlsFingerprintsJa3Hash).map(ja3 => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  grow: false,
  key: ja3,
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 48,
    columnNumber: 13
  }
}, /*#__PURE__*/_react.default.createElement(_ja3_fingerprint.Ja3Fingerprint, {
  scopeId: scopeId,
  eventId: eventId,
  fieldName: _ja3_fingerprint.JA3_HASH_FIELD_NAME,
  contextId: contextId,
  value: ja3,
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 49,
    columnNumber: 15
  }
}))) : null, tlsClientCertificateFingerprintSha1 != null ? (0, _fp.uniq)(tlsClientCertificateFingerprintSha1).map(clientCert => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  grow: false,
  key: clientCert,
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 61,
    columnNumber: 13
  }
}, /*#__PURE__*/_react.default.createElement(_certificate_fingerprint.CertificateFingerprint, {
  scopeId: scopeId,
  eventId: eventId,
  certificateType: "client",
  contextId: contextId,
  fieldName: _certificate_fingerprint.TLS_CLIENT_CERTIFICATE_FINGERPRINT_SHA1_FIELD_NAME,
  value: clientCert,
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 62,
    columnNumber: 15
  }
}))) : null, tlsServerCertificateFingerprintSha1 != null ? (0, _fp.uniq)(tlsServerCertificateFingerprintSha1).map(serverCert => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  grow: false,
  key: serverCert,
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 75,
    columnNumber: 13
  }
}, /*#__PURE__*/_react.default.createElement(_certificate_fingerprint.CertificateFingerprint, {
  scopeId: scopeId,
  eventId: eventId,
  certificateType: "server",
  contextId: contextId,
  fieldName: _certificate_fingerprint.TLS_SERVER_CERTIFICATE_FINGERPRINT_SHA1_FIELD_NAME,
  value: serverCert,
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 76,
    columnNumber: 15
  }
}))) : null));
Fingerprints.displayName = 'Fingerprints';