"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.VALUE_LABEL = exports.VALUE = exports.UNAVAILABLE_OPERATOR = exports.SELECT_AN_OPERATOR = exports.SAVE = exports.OPERATOR = exports.IS_ONE_OF = exports.IS_NOT_ONE_OF = exports.IS_NOT = exports.IS = exports.FIELD_PLACEHOLDER = exports.FIELD = exports.EXISTS = exports.ENTER_ONE_OR_MORE_VALUES = exports.DOES_NOT_EXIST = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DOES_NOT_EXIST = exports.DOES_NOT_EXIST = _i18n.i18n.translate('xpack.securitySolution.editDataProvider.doesNotExistLabel', {
  defaultMessage: 'does not exist'
});
const EXISTS = exports.EXISTS = _i18n.i18n.translate('xpack.securitySolution.editDataProvider.existsLabel', {
  defaultMessage: 'exists'
});
const FIELD = exports.FIELD = _i18n.i18n.translate('xpack.securitySolution.editDataProvider.fieldLabel', {
  defaultMessage: 'Field'
});
const FIELD_PLACEHOLDER = exports.FIELD_PLACEHOLDER = _i18n.i18n.translate('xpack.securitySolution.editDataProvider.placeholder', {
  defaultMessage: 'Select a field'
});
const IS = exports.IS = _i18n.i18n.translate('xpack.securitySolution.editDataProvider.isLabel', {
  defaultMessage: 'is'
});
const IS_ONE_OF = exports.IS_ONE_OF = _i18n.i18n.translate('xpack.securitySolution.editDataProvider.isOneOfLabel', {
  defaultMessage: 'is one of'
});
const IS_NOT = exports.IS_NOT = _i18n.i18n.translate('xpack.securitySolution.editDataProvider.isNotLabel', {
  defaultMessage: 'is not'
});
const IS_NOT_ONE_OF = exports.IS_NOT_ONE_OF = _i18n.i18n.translate('xpack.securitySolution.editDataProvider.isNotOneOfLabel', {
  defaultMessage: 'is not one of'
});
const ENTER_ONE_OR_MORE_VALUES = exports.ENTER_ONE_OR_MORE_VALUES = _i18n.i18n.translate('xpack.securitySolution.editDataProvider.includesPlaceholder', {
  defaultMessage: 'enter one or more values'
});
const OPERATOR = exports.OPERATOR = _i18n.i18n.translate('xpack.securitySolution.editDataProvider.operatorLabel', {
  defaultMessage: 'Operator'
});
const SAVE = exports.SAVE = _i18n.i18n.translate('xpack.securitySolution.editDataProvider.saveButton', {
  defaultMessage: 'Save'
});
const VALUE = exports.VALUE = _i18n.i18n.translate('xpack.securitySolution.editDataProvider.valuePlaceholder', {
  defaultMessage: 'value'
});
const VALUE_LABEL = exports.VALUE_LABEL = _i18n.i18n.translate('xpack.securitySolution.editDataProvider.valueLabel', {
  defaultMessage: 'Value'
});
const SELECT_AN_OPERATOR = exports.SELECT_AN_OPERATOR = _i18n.i18n.translate('xpack.securitySolution.editDataProvider.selectAnOperatorPlaceholder', {
  defaultMessage: 'Select an operator'
});
const UNAVAILABLE_OPERATOR = operator => _i18n.i18n.translate('xpack.securitySolution.editDataProvider.unavailableOperator', {
  values: {
    operator
  },
  defaultMessage: '{operator} operator is unavailable with templates'
});
exports.UNAVAILABLE_OPERATOR = UNAVAILABLE_OPERATOR;