"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.IndicatorsFlyout = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _use_flyout_context = require("../../hooks/use_flyout_context");
var _take_action = require("./take_action");
var _date_formatter = require("../../../../components/date_formatter");
var _indicator = require("../../../../../../common/threat_intelligence/types/indicator");
var _json_tab = require("./json_tab");
var _table_tab = require("./table_tab");
var _unwrap_value = require("../../utils/unwrap_value");
var _overview_tab = require("./overview_tab");
var _test_ids = require("./test_ids");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761322521701505730/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/threat_intelligence/modules/indicators/components/flyout/flyout.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
var TAB_IDS = /*#__PURE__*/function (TAB_IDS) {
  TAB_IDS[TAB_IDS["overview"] = 0] = "overview";
  TAB_IDS[TAB_IDS["table"] = 1] = "table";
  TAB_IDS[TAB_IDS["json"] = 2] = "json";
  return TAB_IDS;
}(TAB_IDS || {});
/**
 * Leverages the {@link EuiFlyout} from the @elastic/eui library to dhow the details of a specific {@link Indicator}.
 */
const IndicatorsFlyout = ({
  indicator,
  closeFlyout,
  kqlBarIntegration = false,
  indicatorName
}) => {
  const [selectedTabId, setSelectedTabId] = (0, _react.useState)(TAB_IDS.overview);
  const tabs = (0, _react.useMemo)(() => [{
    id: TAB_IDS.overview,
    name: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.threatIntelligence.indicator.flyout.overviewTabLabel",
      defaultMessage: "Overview",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 84,
        columnNumber: 11
      }
    }),
    content: /*#__PURE__*/_react.default.createElement(_overview_tab.IndicatorsFlyoutOverview, {
      indicator: indicator,
      onViewAllFieldsInTable: () => setSelectedTabId(TAB_IDS.table),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 90,
        columnNumber: 11
      }
    })
  }, {
    id: TAB_IDS.table,
    name: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.threatIntelligence.indicator.flyout.tableTabLabel",
      defaultMessage: "Table",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 99,
        columnNumber: 11
      }
    }),
    content: /*#__PURE__*/_react.default.createElement(_table_tab.IndicatorsFlyoutTable, {
      indicator: indicator,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 104,
        columnNumber: 18
      }
    })
  }, {
    id: TAB_IDS.json,
    name: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.threatIntelligence.indicator.flyout.jsonTabLabel",
      defaultMessage: "JSON",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 109,
        columnNumber: 11
      }
    }),
    content: /*#__PURE__*/_react.default.createElement(_json_tab.IndicatorsFlyoutJson, {
      indicator: indicator,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 114,
        columnNumber: 18
      }
    })
  }], [indicator]);
  const onSelectedTabChanged = id => setSelectedTabId(id);
  const renderTabs = tabs.map((tab, index) => /*#__PURE__*/_react.default.createElement(_eui.EuiTab, {
    onClick: () => onSelectedTabChanged(tab.id),
    isSelected: tab.id === selectedTabId,
    key: index,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 122,
      columnNumber: 5
    }
  }, tab.name));
  const selectedTabContent = (0, _react.useMemo)(() => {
    var _tabs$find;
    return (_tabs$find = tabs.find(obj => obj.id === selectedTabId)) === null || _tabs$find === void 0 ? void 0 : _tabs$find.content;
  }, [selectedTabId, tabs]);
  const firstSeen = (0, _unwrap_value.unwrapValue)(indicator, _indicator.RawIndicatorFieldId.FirstSeen);
  const flyoutTitleId = (0, _eui.useGeneratedHtmlId)({
    prefix: 'simpleFlyoutTitle'
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlyout, {
    onClose: closeFlyout,
    "aria-labelledby": flyoutTitleId,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 143,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutHeader, {
    hasBorder: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 144,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 145,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement("h2", {
    "data-test-subj": _test_ids.INDICATORS_FLYOUT_TITLE_TEST_ID,
    id: flyoutTitleId,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 146,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.threatIntelligence.indicator.flyout.panelTitleWithOverviewTab",
    defaultMessage: "Indicator details",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 147,
      columnNumber: 13
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 153,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: 'xs',
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 154,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    "data-test-subj": _test_ids.INDICATORS_FLYOUT_SUBTITLE_TEST_ID,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 155,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.threatIntelligence.indicator.flyout.panelSubTitle",
    defaultMessage: "First seen: ",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 156,
      columnNumber: 13
    }
  }), /*#__PURE__*/_react.default.createElement(_date_formatter.DateFormatter, {
    date: firstSeen,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 160,
      columnNumber: 13
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 163,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiTabs, {
    "data-test-subj": _test_ids.INDICATORS_FLYOUT_TABS_TEST_ID,
    css: {
      marginBottom: '-25px'
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 164,
      columnNumber: 9
    }
  }, renderTabs)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 168,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_use_flyout_context.IndicatorsFlyoutContext.Provider, {
    value: {
      kqlBarIntegration,
      indicatorName
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 169,
      columnNumber: 9
    }
  }, selectedTabContent)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutFooter, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 173,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "flexEnd",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 174,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 175,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_take_action.TakeAction, {
    indicator: indicator,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 176,
      columnNumber: 13
    }
  })))));
};
exports.IndicatorsFlyout = IndicatorsFlyout;