"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ThemedBreadcrumbs = exports.StyledTitle = exports.StyledTime = exports.StyledLabelTitle = exports.StyledLabelContainer = exports.StyledDescriptionList = exports.StyledButtonTextContainer = exports.StyledAnalyzedEvent = exports.BoldCode = void 0;
var _react = require("react");
var _eui = require("@elastic/eui");
var _styledComponents = _interopRequireDefault(require("styled-components"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Used by the nodeDetail view, eventDetail view and control panel to show attributes of the related events.
 */
const StyledDescriptionList = exports.StyledDescriptionList = /*#__PURE__*/(0, _react.memo)((0, _styledComponents.default)(_eui.EuiDescriptionList)`
  .euiDescriptionList__title {
    word-break: normal;
  }
  .euiDescriptionList__title,
  .euiDescriptionList__description {
    overflow-wrap: break-word;
  }
`);

/**
 * Used by the nodeDetail view for the label of the node.
 */
const StyledTitle = exports.StyledTitle = (0, _styledComponents.default)('h4')`
  overflow-wrap: break-word;
`;

/**
 * Styled version of EuiBreadcrumbs that is used by the breadcrumbs in each panel.
 */
const ThemedBreadcrumbs = exports.ThemedBreadcrumbs = (0, _styledComponents.default)(_eui.EuiBreadcrumbs)`
  &.euiBreadcrumbs {
    background-color: ${props => props.background};
    color: ${props => props.text};
    padding: 1em;
    border-radius: 5px;
  }

  & .euiBreadcrumbSeparator {
    background: ${props => props.text};
  }
`;

/**
 * Used in the links to nodes on the node list panel.
 */
const StyledButtonTextContainer = exports.StyledButtonTextContainer = _styledComponents.default.div`
  align-items: center;
  display: flex;
  flex-direction: row;
`;

/**
 * Used in the node list panel to call out the event that is represented by the databaseDocumentID.
 */
const StyledAnalyzedEvent = exports.StyledAnalyzedEvent = _styledComponents.default.div`
  color: ${props => props.color};
  font-size: 10.5px;
  font-weight: 700;
`;

/**
 * Used to style the node name in the node list panel view.
 */
const StyledLabelTitle = exports.StyledLabelTitle = _styledComponents.default.div``;

/**
 * Used by the node list view. Wraps the title of the node and the 'Analyzed event' marker.
 */
const StyledLabelContainer = exports.StyledLabelContainer = _styledComponents.default.div`
  display: inline-block;
  flex: 3;
  min-width: 0;

  ${StyledAnalyzedEvent},
  ${StyledLabelTitle} {
    overflow: hidden;
    text-align: left;
    text-overflow: ellipsis;
    white-space: nowrap;
  }
`;

/**
 * A bold version of EuiCode to display certain titles with
 */
const BoldCode = exports.BoldCode = (0, _styledComponents.default)(_eui.EuiCode)`
  &.euiCodeBlock code.euiCodeBlock__code {
    font-weight: 900;
  }
`;

/**
 * A component to keep time representations in blocks so they don't wrap
 * and look bad.
 */
const StyledTime = exports.StyledTime = (0, _styledComponents.default)('time')`
  display: inline-block;
  text-align: start;
`;