"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EventDetail = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _reactRedux = require("react-redux");
var _styles = require("./styles");
var _generated_text = require("../generated_text");
var _cell_actions = require("../../../common/components/cell_actions");
var _helpers = require("../../../helpers");
var _breadcrumbs = require("./breadcrumbs");
var eventModel = _interopRequireWildcard(require("../../../../common/endpoint/models/event"));
var selectors = _interopRequireWildcard(require("../../store/selectors"));
var _panel_loading = require("./panel_loading");
var _panel_content_error = require("./panel_content_error");
var _descriptive_name = require("./descriptive_name");
var _use_link_props = require("../use_link_props");
var _deep_object_entries = require("./deep_object_entries");
var _use_formatted_date = require("./use_formatted_date");
var nodeDataModel = _interopRequireWildcard(require("../../models/node_data"));
var _expand_dotted = require("../../../../common/utils/expand_dotted");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761322521701505730/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/resolver/view/panels/event_detail.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
/* eslint-disable no-continue */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const eventDetailRequestError = _i18n.i18n.translate('xpack.securitySolution.resolver.panel.eventDetail.requestError', {
  defaultMessage: 'Event details were unable to be retrieved'
});
const EventDetail = exports.EventDetail = /*#__PURE__*/(0, _react.memo)(function EventDetail({
  id,
  nodeID,
  eventCategory: eventType
}) {
  const isEventLoading = (0, _reactRedux.useSelector)(state => selectors.isCurrentRelatedEventLoading(state.analyzer[id]));
  const isTreeLoading = (0, _reactRedux.useSelector)(state => selectors.isTreeLoading(state.analyzer[id]));
  const processEvent = (0, _reactRedux.useSelector)(state => nodeDataModel.firstEvent(selectors.nodeDataForID(state.analyzer[id])(nodeID)));
  const nodeStatus = (0, _reactRedux.useSelector)(state => selectors.nodeDataStatus(state.analyzer[id])(nodeID));
  const isNodeDataLoading = nodeStatus === 'loading';
  const isLoading = isEventLoading || isTreeLoading || isNodeDataLoading;
  const event = (0, _reactRedux.useSelector)(state => selectors.currentRelatedEventData(state.analyzer[id]));
  return isLoading ? /*#__PURE__*/_react.default.createElement(_panel_loading.PanelLoading, {
    id: id,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 75,
      columnNumber: 5
    }
  }) : event ? /*#__PURE__*/_react.default.createElement(EventDetailContents, {
    id: id,
    nodeID: nodeID,
    event: event,
    processEvent: processEvent,
    eventType: eventType,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 77,
      columnNumber: 5
    }
  }) : /*#__PURE__*/_react.default.createElement(_panel_content_error.PanelContentError, {
    id: id,
    translatedErrorMessage: eventDetailRequestError,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 85,
      columnNumber: 5
    }
  });
});

/**
 * This view presents a detailed view of all the available data for a related event, split and titled by the "section"
 * it appears in the underlying ResolverEvent
 */
// eslint-disable-next-line react/display-name
const EventDetailContents = /*#__PURE__*/(0, _react.memo)(function ({
  id,
  nodeID,
  event,
  eventType,
  processEvent
}) {
  const timestamp = eventModel.timestampSafeVersion(event);
  const formattedDate = (0, _use_formatted_date.useFormattedDate)(timestamp) || _i18n.i18n.translate('xpack.securitySolution.enpdoint.resolver.panelutils.noTimestampRetrieved', {
    defaultMessage: 'No timestamp retrieved'
  });
  const nodeName = processEvent ? eventModel.processNameSafeVersion(processEvent) : null;
  return /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": "resolver:panel:event-detail",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 120,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(EventDetailBreadcrumbs, {
    id: id,
    nodeID: nodeID,
    nodeName: nodeName,
    event: event,
    breadcrumbEventCategory: eventType,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 121,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 128,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 129,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_styles.BoldCode, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 130,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.endpoint.resolver.panel.relatedEventDetail.categoryAndType",
    values: {
      category: eventType,
      eventType: String(eventModel.eventType(event))
    },
    defaultMessage: "{category} {eventType}",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 131,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_styles.StyledTime, {
    dateTime: formattedDate,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 140,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.endpoint.resolver.panel.relatedEventDetail.atTime",
    values: {
      date: formattedDate
    },
    defaultMessage: "@ {date}",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 141,
      columnNumber: 11
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 148,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(StyledDescriptiveName, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 149,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_generated_text.GeneratedText, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 150,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_descriptive_name.DescriptiveName, {
    event: event,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 151,
      columnNumber: 11
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 154,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(EventDetailFields, {
    event: event,
    id: id,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 155,
      columnNumber: 7
    }
  }));
});
function EventDetailFields({
  event,
  id
}) {
  const descriptions = (0, _react.useMemo)(() => {
    const returnValue = [];
    const expandedEventObject = (0, _expand_dotted.expandDottedObject)(event);
    for (const [key, value] of Object.entries(expandedEventObject)) {
      // ignore these keys
      if (key === 'agent' || key === 'ecs' || key === '@timestamp' || !value) {
        continue;
      }
      const description = (0, _deep_object_entries.deepObjectEntries)(value).map(([path, fieldValue]) => {
        // The field name is the 'namespace' key as well as the rest of the path, joined with '.'
        const fieldName = [key, ...path].join('.');
        return {
          title: fieldName,
          description: String(fieldValue)
        };
      });
      returnValue.push(...description);
    }
    return returnValue;
  }, [event]);
  const search = {
    box: {
      incremental: true,
      schema: true
    }
  };
  const columns = [{
    field: 'title',
    'data-test-subj': 'resolver:panel:event-detail:event-field-title',
    name: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.endpoint.resolver.panel.eventDetail.fieldTitle",
      defaultMessage: "Field",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 200,
        columnNumber: 9
      }
    }),
    width: 'fit-content(8em)',
    sortable: true
  }, {
    name: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.endpoint.resolver.panel.eventDetail.valueTitle",
      defaultMessage: "Value",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 210,
        columnNumber: 9
      }
    }),
    render(data) {
      return /*#__PURE__*/_react.default.createElement(_cell_actions.SecurityCellActions, {
        data: {
          field: data.title,
          value: data.description
        },
        visibleCellActions: 5,
        triggerId: _cell_actions.SecurityCellActionsTrigger.DEFAULT,
        mode: _cell_actions.CellActionsMode.HOVER_DOWN,
        sourcererScopeId: (0, _helpers.getSourcererScopeId)(id),
        metadata: {
          scopeId: id
        },
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 217,
          columnNumber: 11
        }
      }, data.description);
    }
  }];
  return /*#__PURE__*/_react.default.createElement(_eui.EuiInMemoryTable, {
    items: descriptions,
    columns: columns,
    search: search,
    pagination: true,
    sorting: true,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 235,
      columnNumber: 5
    }
  });
}
function EventDetailBreadcrumbs({
  id,
  nodeID,
  nodeName,
  event,
  breadcrumbEventCategory
}) {
  const countByCategory = (0, _reactRedux.useSelector)(state => selectors.relatedEventCountOfTypeForNode(state.analyzer[id])(nodeID, breadcrumbEventCategory));
  const relatedEventCount = (0, _reactRedux.useSelector)(state => selectors.relatedEventTotalCount(state.analyzer[id])(nodeID));
  const nodesLinkNavProps = (0, _use_link_props.useLinkProps)(id, {
    panelView: 'nodes'
  });
  const nodeDetailLinkNavProps = (0, _use_link_props.useLinkProps)(id, {
    panelView: 'nodeDetail',
    panelParameters: {
      nodeID
    }
  });
  const nodeEventsLinkNavProps = (0, _use_link_props.useLinkProps)(id, {
    panelView: 'nodeEvents',
    panelParameters: {
      nodeID
    }
  });
  const nodeEventsInCategoryLinkNavProps = (0, _use_link_props.useLinkProps)(id, {
    panelView: 'nodeEventsInCategory',
    panelParameters: {
      nodeID,
      eventCategory: breadcrumbEventCategory
    }
  });
  const breadcrumbs = (0, _react.useMemo)(() => {
    const crumbs = [{
      text: _i18n.i18n.translate('xpack.securitySolution.endpoint.resolver.panel.relatedEventDetail.events', {
        defaultMessage: 'Events'
      }),
      'data-test-subj': 'resolver:event-detail:breadcrumbs:node-list-link',
      ...nodesLinkNavProps
    }, {
      text: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.securitySolution.endpoint.resolver.panel.relatedEventDetail.numberOfEvents",
        values: {
          totalCount: relatedEventCount
        },
        defaultMessage: "{totalCount} Events",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 296,
          columnNumber: 11
        }
      }),
      ...nodeEventsLinkNavProps
    }, {
      text: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.securitySolution.endpoint.resolver.panel.relatedEventDetail.countByCategory",
        values: {
          count: countByCategory,
          category: breadcrumbEventCategory
        },
        defaultMessage: "{count} {category}",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 306,
          columnNumber: 11
        }
      }),
      ...nodeEventsInCategoryLinkNavProps
    }, {
      text: /*#__PURE__*/_react.default.createElement(_descriptive_name.DescriptiveName, {
        event: event,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 315,
          columnNumber: 15
        }
      })
    }];
    if (nodeName) {
      crumbs.splice(1, 0, {
        text: nodeName,
        ...nodeDetailLinkNavProps
      });
    }
    return crumbs;
  }, [breadcrumbEventCategory, countByCategory, event, nodeDetailLinkNavProps, nodeEventsLinkNavProps, nodeName, relatedEventCount, nodesLinkNavProps, nodeEventsInCategoryLinkNavProps]);
  return /*#__PURE__*/_react.default.createElement(_breadcrumbs.Breadcrumbs, {
    breadcrumbs: breadcrumbs,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 338,
      columnNumber: 10
    }
  });
}

// Also prevents horizontal scrollbars on long descriptive names
const StyledDescriptiveName = /*#__PURE__*/(0, _react.memo)((0, _styledComponents.default)(_eui.EuiText)`
  padding-right: 1em;
  overflow-wrap: break-word;
`);