"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.panelViewAndParameters = panelViewAndParameters;
var _rison = require("@kbn/rison");
var _location_search = require("../models/location_search");
var _parameter_name = require("./parameter_name");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Return a value `PanelViewAndParameters` based on `locationSearch` and `resolverComponentInstanceID`.
 * Used by selectors.
 */
function panelViewAndParameters({
  locationSearch,
  resolverComponentInstanceID
}) {
  if (locationSearch === undefined || resolverComponentInstanceID === undefined) {
    // Equivalent to `null`
    return defaultParameters();
  }
  const urlSearchParams = new URLSearchParams(locationSearch);
  const value = urlSearchParams.get((0, _parameter_name.parameterName)(resolverComponentInstanceID));
  if (value === null) {
    // Equivalent to `null`
    return defaultParameters();
  }
  const decodedValue = (0, _rison.decode)(value);
  if ((0, _location_search.isPanelViewAndParameters)(decodedValue)) {
    return decodedValue;
  }
  return defaultParameters();
}

/**
 * The default parameters to use when no (valid) location search is available.
 */
function defaultParameters() {
  // Note, this really should be a selector. it needs to know about the state of the app so it can select
  // the origin event.
  return {
    panelView: 'nodes'
  };
}