"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.userZoomed = exports.userStoppedPanning = exports.userStartedPanning = exports.userSetZoomLevel = exports.userSetRasterSize = exports.userSetPositionOfCamera = exports.userNudgedCamera = exports.userMovedPointer = exports.userClickedZoomOut = exports.userClickedZoomIn = void 0;
var _typescriptFsa = _interopRequireDefault(require("typescript-fsa"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const actionCreator = (0, _typescriptFsa.default)('x-pack/security_solution/analyzer');
const userSetZoomLevel = exports.userSetZoomLevel = actionCreator('USER_SET_ZOOM_LEVEL');
const userClickedZoomOut = exports.userClickedZoomOut = actionCreator('USER_CLICKED_ZOOM_OUT');
const userClickedZoomIn = exports.userClickedZoomIn = actionCreator('USER_CLICKED_ZOOM_IN');
const userZoomed = exports.userZoomed = actionCreator('USER_ZOOMED');
const userSetRasterSize = exports.userSetRasterSize = actionCreator('USER_SET_RASTER_SIZE');

/**
 * When the user warps the camera to an exact point instantly.
 */
const userSetPositionOfCamera = exports.userSetPositionOfCamera = actionCreator('USER_SET_CAMERA_POSITION');
const userStartedPanning = exports.userStartedPanning = actionCreator('USER_STARTED_PANNING');
const userStoppedPanning = exports.userStoppedPanning = actionCreator('USER_STOPPED_PANNING');
const userNudgedCamera = exports.userNudgedCamera = actionCreator('USER_NUDGE_CAMERA');
const userMovedPointer = exports.userMovedPointer = actionCreator('USER_MOVED_POINTER');