"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DetectionResponse = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _common = require("../../../common");
var _constants = require("../../common/store/inputs/constants");
var _use_experimental_features = require("../../common/hooks/use_experimental_features");
var _soc_trends = require("../components/detection_response/soc_trends");
var _search_bar = require("../../common/components/search_bar");
var _page_wrapper = require("../../common/components/page_wrapper");
var _spy_routes = require("../../common/utils/route/spy_routes");
var _types = require("../../app/types");
var _containers = require("../../sourcerer/containers");
var _use_signal_index = require("../../detections/containers/detection_engine/alerts/use_signal_index");
var _use_alerts_privileges = require("../../detections/containers/detection_engine/alerts/use_alerts_privileges");
var _header_page = require("../../common/components/header_page");
var _empty_prompt = require("../../common/components/empty_prompt");
var _alerts_by_status = require("../components/detection_response/alerts_by_status");
var _host_alerts_table = require("../components/detection_response/host_alerts_table");
var _rule_alerts_table = require("../components/detection_response/rule_alerts_table");
var _user_alerts_table = require("../components/detection_response/user_alerts_table");
var i18n = _interopRequireWildcard(require("./translations"));
var _cases_table = require("../components/detection_response/cases_table");
var _cases_by_status = require("../components/detection_response/cases_by_status");
var _no_privileges = require("../../common/components/no_privileges");
var _filters_global = require("../../common/components/filters_global");
var _use_global_filter_query = require("../../common/hooks/use_global_filter_query");
var _kibana = require("../../common/lib/kibana");
var _use_data_view = require("../../data_view_manager/hooks/use_data_view");
var _page_loader = require("../../common/components/page_loader");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761322521701505730/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/overview/pages/detection_response.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const DetectionResponseComponent = () => {
  var _experimentalDataView;
  const {
    cases
  } = (0, _kibana.useKibana)().services;
  const {
    filterQuery
  } = (0, _use_global_filter_query.useGlobalFilterQuery)();
  const {
    indicesExist: oldIndicesExist,
    loading: oldIsSourcererLoading,
    sourcererDataView: oldSourcererDataView
  } = (0, _containers.useSourcererDataView)();
  const newDataViewPickerEnabled = (0, _use_experimental_features.useIsExperimentalFeatureEnabled)('newDataViewPickerEnabled');
  const {
    dataView: experimentalDataView,
    status
  } = (0, _use_data_view.useDataView)();
  const indicesExist = newDataViewPickerEnabled ? !!((_experimentalDataView = experimentalDataView.matchedIndices) !== null && _experimentalDataView !== void 0 && _experimentalDataView.length) : oldIndicesExist;
  const isSourcererLoading = newDataViewPickerEnabled ? status !== 'ready' : oldIsSourcererLoading;
  const {
    signalIndexName
  } = (0, _use_signal_index.useSignalIndex)();
  const {
    hasKibanaREAD,
    hasIndexRead
  } = (0, _use_alerts_privileges.useAlertsPrivileges)();
  const userCasesPermissions = cases.helpers.canUseCases([_common.APP_ID]);
  const canReadCases = userCasesPermissions.read;
  const canReadAlerts = hasKibanaREAD && hasIndexRead;
  const isSocTrendsEnabled = (0, _use_experimental_features.useIsExperimentalFeatureEnabled)('socTrendsEnabled');
  const additionalFilters = (0, _react.useMemo)(() => filterQuery ? [filterQuery] : [], [filterQuery]);
  if (!canReadAlerts && !canReadCases) {
    return /*#__PURE__*/_react.default.createElement(_no_privileges.NoPrivileges, {
      docLinkSelector: docLinks => docLinks.siem.privileges,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 65,
        columnNumber: 12
      }
    });
  }
  if (newDataViewPickerEnabled && status === 'pristine') {
    return /*#__PURE__*/_react.default.createElement(_page_loader.PageLoader, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 69,
        columnNumber: 12
      }
    });
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, indicesExist ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_filters_global.FiltersGlobal, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 76,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_search_bar.SiemSearchBar, {
    id: _constants.InputsModelId.global,
    sourcererDataView: newDataViewPickerEnabled ? experimentalDataView : oldSourcererDataView,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 77,
      columnNumber: 13
    }
  })), /*#__PURE__*/_react.default.createElement(_page_wrapper.SecuritySolutionPageWrapper, {
    "data-test-subj": "detectionResponsePage",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 84,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_header_page.HeaderPage, {
    title: i18n.DETECTION_RESPONSE_TITLE,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 85,
      columnNumber: 13
    }
  }), isSourcererLoading ? /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
    size: "l",
    "data-test-subj": "detectionResponseLoader",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 87,
      columnNumber: 15
    }
  }) : /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    "data-test-subj": "detectionResponseSections",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 89,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 90,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 91,
      columnNumber: 19
    }
  }, canReadAlerts && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 93,
      columnNumber: 23
    }
  }, /*#__PURE__*/_react.default.createElement(_alerts_by_status.AlertsByStatus, {
    signalIndexName: signalIndexName,
    additionalFilters: additionalFilters,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 94,
      columnNumber: 25
    }
  })), canReadCases && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 101,
      columnNumber: 23
    }
  }, /*#__PURE__*/_react.default.createElement(_cases_by_status.CasesByStatus, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 102,
      columnNumber: 25
    }
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 108,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 109,
      columnNumber: 19
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 110,
      columnNumber: 21
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 111,
      columnNumber: 23
    }
  }, canReadAlerts && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 113,
      columnNumber: 27
    }
  }, /*#__PURE__*/_react.default.createElement(_rule_alerts_table.RuleAlertsTable, {
    signalIndexName: signalIndexName,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 114,
      columnNumber: 29
    }
  })), canReadCases && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 118,
      columnNumber: 27
    }
  }, /*#__PURE__*/_react.default.createElement(_cases_table.CasesTable, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 119,
      columnNumber: 29
    }
  })))), isSocTrendsEnabled && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 125,
      columnNumber: 23
    }
  }, /*#__PURE__*/_react.default.createElement(_soc_trends.SocTrends, {
    signalIndexName: signalIndexName,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 126,
      columnNumber: 25
    }
  })))), canReadAlerts && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 133,
      columnNumber: 19
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 134,
      columnNumber: 21
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 135,
      columnNumber: 23
    }
  }, /*#__PURE__*/_react.default.createElement(_host_alerts_table.HostAlertsTable, {
    signalIndexName: signalIndexName,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 136,
      columnNumber: 25
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 138,
      columnNumber: 23
    }
  }, /*#__PURE__*/_react.default.createElement(_user_alerts_table.UserAlertsTable, {
    signalIndexName: signalIndexName,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 139,
      columnNumber: 25
    }
  }))))))) : /*#__PURE__*/_react.default.createElement(_empty_prompt.EmptyPrompt, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 149,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_spy_routes.SpyRoute, {
    pageName: _types.SecurityPageName.detectionAndResponse,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 152,
      columnNumber: 7
    }
  }));
};
const DetectionResponse = exports.DetectionResponse = /*#__PURE__*/_react.default.memo(DetectionResponseComponent);