"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.USER_RISK_SCORE = exports.USER_RISK_LEVEL = exports.USER_ID = exports.USER_DOMAIN = exports.MAX_ANOMALY_SCORE_BY_JOB = exports.LAST_SEEN = exports.INSPECT_TITLE = exports.HOST_OS = exports.HOST_IP = exports.HOST_FAMILY = exports.FIRST_SEEN = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const USER_ID = exports.USER_ID = _i18n.i18n.translate('xpack.securitySolution.user.details.overview.userIdTitle', {
  defaultMessage: 'User ID'
});
const USER_DOMAIN = exports.USER_DOMAIN = _i18n.i18n.translate('xpack.securitySolution.user.details.overview.userDomainTitle', {
  defaultMessage: 'Domain'
});
const HOST_FAMILY = exports.HOST_FAMILY = _i18n.i18n.translate('xpack.securitySolution.user.details.overview.familyTitle', {
  defaultMessage: 'Family'
});
const HOST_IP = exports.HOST_IP = _i18n.i18n.translate('xpack.securitySolution.user.details.overview.ipAddressesTitle', {
  defaultMessage: 'IP addresses'
});
const HOST_OS = exports.HOST_OS = _i18n.i18n.translate('xpack.securitySolution.user.details.overview.osTitle', {
  defaultMessage: 'Operating system'
});
const FIRST_SEEN = exports.FIRST_SEEN = _i18n.i18n.translate('xpack.securitySolution.network.ipDetails.ipOverview.firstSeenTitle', {
  defaultMessage: 'First seen'
});
const LAST_SEEN = exports.LAST_SEEN = _i18n.i18n.translate('xpack.securitySolution.user.ipDetails.ipOverview.lastSeenTitle', {
  defaultMessage: 'Last seen'
});
const INSPECT_TITLE = exports.INSPECT_TITLE = _i18n.i18n.translate('xpack.securitySolution.user.details.overview.inspectTitle', {
  defaultMessage: 'User overview'
});
const MAX_ANOMALY_SCORE_BY_JOB = exports.MAX_ANOMALY_SCORE_BY_JOB = _i18n.i18n.translate('xpack.securitySolution.user.details.overview.maxAnomalyScoreByJobTitle', {
  defaultMessage: 'Max anomaly score by job'
});
const USER_RISK_SCORE = exports.USER_RISK_SCORE = _i18n.i18n.translate('xpack.securitySolution.user.details.overview.userRiskScoreTitle', {
  defaultMessage: 'User risk score'
});
const USER_RISK_LEVEL = exports.USER_RISK_LEVEL = _i18n.i18n.translate('xpack.securitySolution.user.details.overview.userRiskLevel', {
  defaultMessage: 'User risk level'
});