"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SignalsByCategory = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactRedux = require("react-redux");
var _alerts_histogram_panel = require("../../../detections/components/alerts_kpis/alerts_histogram_panel");
var _use_signal_index = require("../../../detections/containers/detection_engine/alerts/use_signal_index");
var _actions = require("../../../common/store/inputs/actions");
var _constants = require("../../../common/store/inputs/constants");
var i18n = _interopRequireWildcard(require("../../pages/translations"));
var _use_filters_for_signals_by_category = require("./use_filters_for_signals_by_category");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761322521701505730/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/overview/components/signals_by_category/signals_by_category.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const SignalsByCategoryComponent = ({
  filters,
  headerChildren,
  onlyField,
  paddingSize,
  setAbsoluteRangeDatePickerTarget = _constants.InputsModelId.global,
  hideQueryToggle = false
}) => {
  const dispatch = (0, _reactRedux.useDispatch)();
  const {
    signalIndexName
  } = (0, _use_signal_index.useSignalIndex)();
  const filtersForSignalsByCategory = (0, _use_filters_for_signals_by_category.useFiltersForSignalsByCategory)(filters);
  const updateDateRangeCallback = (0, _react.useCallback)(({
    x
  }) => {
    if (!x) {
      return;
    }
    const [min, max] = x;
    dispatch((0, _actions.setAbsoluteRangeDatePicker)({
      id: setAbsoluteRangeDatePickerTarget,
      from: new Date(min).toISOString(),
      to: new Date(max).toISOString()
    }));
  }, [dispatch, setAbsoluteRangeDatePickerTarget]);
  return /*#__PURE__*/_react.default.createElement(_alerts_histogram_panel.AlertsHistogramPanel, {
    filters: filtersForSignalsByCategory,
    headerChildren: headerChildren,
    onlyField: onlyField,
    paddingSize: paddingSize,
    showLinkToAlerts: onlyField == null ? true : false,
    showStackBy: onlyField == null,
    showTotalAlertsCount: true,
    signalIndexName: signalIndexName,
    title: i18n.ALERT_TREND,
    titleSize: onlyField == null ? 'm' : 's',
    updateDateRange: updateDateRangeCallback,
    hideQueryToggle: hideQueryToggle,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 65,
      columnNumber: 5
    }
  });
};
SignalsByCategoryComponent.displayName = 'SignalsByCategoryComponent';
const SignalsByCategory = exports.SignalsByCategory = /*#__PURE__*/_react.default.memo(SignalsByCategoryComponent);