"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DashboardMigrationsPanels = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _constants = require("../../../../../../../../common/siem_migrations/constants");
var _upload_panel = require("../../../../../../../siem_migrations/dashboards/components/status_panels/upload_panel");
var _migration_ready_panel = require("../../../../../../../siem_migrations/dashboards/components/migration_status_panels/migration_ready_panel");
var _components = require("../../../../../../../siem_migrations/common/components");
var _migration_result_panel = require("../../../../../../../siem_migrations/dashboards/components/migration_status_panels/migration_result_panel");
var _missing_ai_connector_callout = require("../common/missing_ai_connector_callout");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761322521701505730/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/onboarding/components/onboarding_body/cards/siem_migrations/start_migration/dashboards/dashboard_migrations_panels.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const DashboardMigrationsPanels = exports.DashboardMigrationsPanels = /*#__PURE__*/_react.default.memo(({
  migrationsStats,
  isConnectorsCardComplete,
  expandConnectorsCard
}) => {
  const latestMigrationsStats = (0, _react.useMemo)(() => migrationsStats.slice().reverse(), [migrationsStats]);
  const [expandedCardId, setExpandedCardId] = (0, _react.useState)(() => {
    var _latestMigrationsStat;
    if (((_latestMigrationsStat = latestMigrationsStats[0]) === null || _latestMigrationsStat === void 0 ? void 0 : _latestMigrationsStat.status) === _constants.SiemMigrationTaskStatus.FINISHED) {
      var _latestMigrationsStat2;
      return (_latestMigrationsStat2 = latestMigrationsStats[0]) === null || _latestMigrationsStat2 === void 0 ? void 0 : _latestMigrationsStat2.id;
    }
    return undefined;
  });
  (0, _react.useEffect)(() => {
    if (!expandedCardId && latestMigrationsStats.length > 0) {
      const runningMigration = latestMigrationsStats.find(({
        status
      }) => status === _constants.SiemMigrationTaskStatus.RUNNING);
      if (runningMigration) {
        setExpandedCardId(runningMigration.id); // Set the next migration to be expanded when it finishes
      }
    }
  }, [latestMigrationsStats, expandedCardId]);
  const getOnToggleCollapsed = (0, _react.useCallback)(id => isCollapsed => {
    setExpandedCardId(isCollapsed ? undefined : id);
  }, []);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    "data-test-subj": "dashboardMigrationPanelGroup",
    direction: "column",
    gutterSize: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 55,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 56,
      columnNumber: 9
    }
  }, !isConnectorsCardComplete && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_missing_ai_connector_callout.MissingAIConnectorCallout, {
    onExpandAiConnectorsCard: expandConnectorsCard,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 59,
      columnNumber: 15
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 60,
      columnNumber: 15
    }
  })), /*#__PURE__*/_react.default.createElement(_upload_panel.UploadDashboardsPanel, {
    isUploadMore: latestMigrationsStats.length > 0,
    isDisabled: !isConnectorsCardComplete,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 63,
      columnNumber: 11
    }
  })), latestMigrationsStats.map(migrationStats => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    "data-test-subj": `migration-${migrationStats.id}`,
    grow: false,
    key: migrationStats.id,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 70,
      columnNumber: 11
    }
  }, [_constants.SiemMigrationTaskStatus.READY, _constants.SiemMigrationTaskStatus.INTERRUPTED, _constants.SiemMigrationTaskStatus.STOPPED].includes(migrationStats.status) && /*#__PURE__*/_react.default.createElement(_migration_ready_panel.MigrationReadyPanel, {
    migrationStats: migrationStats,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 80,
      columnNumber: 15
    }
  }), migrationStats.status === _constants.SiemMigrationTaskStatus.RUNNING && /*#__PURE__*/_react.default.createElement(_components.MigrationProgressPanel, {
    migrationStats: migrationStats,
    migrationType: "dashboard",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 83,
      columnNumber: 15
    }
  }), migrationStats.status === _constants.SiemMigrationTaskStatus.FINISHED && /*#__PURE__*/_react.default.createElement(_migration_result_panel.DashboardMigrationResultPanel, {
    migrationStats: migrationStats,
    isCollapsed: migrationStats.id !== expandedCardId,
    onToggleCollapsed: getOnToggleCollapsed(migrationStats.id),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 86,
      columnNumber: 15
    }
  }))));
});
DashboardMigrationsPanels.displayName = 'DashboardMigrationsPanels';