"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.checkAssistantCardComplete = void 0;
var _i18n = require("@kbn/i18n");
var _ai_connectors = require("../../../../../../common/utils/connectors/ai_connectors");
var _authz = require("./authz");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const completeBadgeText = count => _i18n.i18n.translate('xpack.securitySolution.onboarding.assistantCard.badge.completeText', {
  defaultMessage: '{count} AI {count, plural, one {connector} other {connectors}} added',
  values: {
    count
  }
});
const checkAssistantCardComplete = async ({
  http,
  application,
  settings
}) => {
  const authz = (0, _authz.getConnectorsAuthz)(application.capabilities);
  if (!authz.canReadConnectors) {
    return {
      isComplete: false,
      metadata: {
        connectors: [],
        ...authz
      }
    };
  }
  const aiConnectors = await (0, _ai_connectors.loadAiConnectors)({
    http,
    settings
  });
  return {
    isComplete: aiConnectors.length > 0,
    completeBadgeText: completeBadgeText(aiConnectors.length),
    metadata: {
      connectors: aiConnectors,
      ...authz
    }
  };
};
exports.checkAssistantCardComplete = checkAssistantCardComplete;