"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useCanAccessSomeArtifacts = void 0;
var _react = require("react");
var _user_privileges = require("../../../../../../common/components/user_privileges");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Checks to see if the current user can access at least one artifact page.
 * Note that this hook will return `false` if the Authz is still being loaded.
 */
const useCanAccessSomeArtifacts = () => {
  const {
    canReadBlocklist,
    canReadEventFilters,
    canReadTrustedApplications,
    canReadHostIsolationExceptions
  } = (0, _user_privileges.useUserPrivileges)().endpointPrivileges;
  return (0, _react.useMemo)(() => {
    return canReadBlocklist || canReadEventFilters || canReadTrustedApplications || canReadHostIsolationExceptions;
  }, [canReadBlocklist, canReadEventFilters, canReadTrustedApplications, canReadHostIsolationExceptions]);
};
exports.useCanAccessSomeArtifacts = useCanAccessSomeArtifacts;