"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.POLICY_STATUS_TO_TEXT = exports.POLICY_STATUS_TO_HEALTH_COLOR = exports.POLICY_STATUS_TO_BADGE_COLOR = exports.HOST_STATUS_TO_BADGE_COLOR = void 0;
var _i18n = require("@kbn/i18n");
var _types = require("../../../../../common/endpoint/types");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const HOST_STATUS_TO_BADGE_COLOR = exports.HOST_STATUS_TO_BADGE_COLOR = Object.freeze({
  [_types.HostStatus.HEALTHY]: 'success',
  [_types.HostStatus.UNHEALTHY]: 'warning',
  [_types.HostStatus.UPDATING]: 'primary',
  [_types.HostStatus.OFFLINE]: 'default',
  [_types.HostStatus.INACTIVE]: 'default',
  [_types.HostStatus.UNENROLLED]: 'default'
});
const POLICY_STATUS_TO_HEALTH_COLOR = exports.POLICY_STATUS_TO_HEALTH_COLOR = Object.freeze({
  success: 'success',
  warning: 'warning',
  failure: 'danger',
  unsupported: 'default'
});
const POLICY_STATUS_TO_BADGE_COLOR = exports.POLICY_STATUS_TO_BADGE_COLOR = Object.freeze({
  success: 'success',
  warning: 'warning',
  failure: 'danger',
  unsupported: 'default'
});
const POLICY_STATUS_TO_TEXT = exports.POLICY_STATUS_TO_TEXT = Object.freeze({
  success: _i18n.i18n.translate('xpack.securitySolution.policyStatusText.success', {
    defaultMessage: 'Success'
  }),
  warning: _i18n.i18n.translate('xpack.securitySolution.policyStatusText.warning', {
    defaultMessage: 'Warning'
  }),
  failure: _i18n.i18n.translate('xpack.securitySolution.policyStatusText.failure', {
    defaultMessage: 'Failure'
  }),
  unsupported: _i18n.i18n.translate('xpack.securitySolution.policyStatusText.unsupported', {
    defaultMessage: 'Unsupported'
  })
});