"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.BackToEndpointDetailsFlyoutSubHeader = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _routing = require("../../../../../common/routing");
var _use_navigate_by_router_event_handler = require("../../../../../../common/hooks/endpoint/use_navigate_by_router_event_handler");
var _hooks = require("../../hooks");
var _selectors = require("../../../store/selectors");
var _hooks2 = require("../../../../../../common/lib/kibana/hooks");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761322521701505730/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/management/pages/endpoint_hosts/view/details/components/back_to_endpoint_details_flyout_subheader.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const BackToEndpointDetailsFlyoutSubHeader = exports.BackToEndpointDetailsFlyoutSubHeader = /*#__PURE__*/(0, _react.memo)(({
  endpointId
}) => {
  var _backButtonProps$href;
  const {
    getAppUrl
  } = (0, _hooks2.useAppUrl)();
  const {
    show,
    ...currentUrlQueryParams
  } = (0, _hooks.useEndpointSelector)(_selectors.uiQueryParams);
  const detailsRoutePath = (0, _react.useMemo)(() => (0, _routing.getEndpointDetailsPath)({
    name: 'endpointDetails',
    ...currentUrlQueryParams,
    selected_endpoint: endpointId
  }), [currentUrlQueryParams, endpointId]);
  const backToDetailsClickHandler = (0, _use_navigate_by_router_event_handler.useNavigateByRouterEventHandler)(detailsRoutePath);
  const backButtonProps = (0, _react.useMemo)(() => {
    return {
      title: _i18n.i18n.translate('xpack.securitySolution.endpoint.policyResponse.backLinkTitle', {
        defaultMessage: 'Endpoint details'
      }),
      href: getAppUrl({
        path: detailsRoutePath
      }),
      onClick: backToDetailsClickHandler
    };
  }, [backToDetailsClickHandler, getAppUrl, detailsRoutePath]);
  return /*#__PURE__*/_react.default.createElement("div", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 53,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    flush: "both",
    "data-test-subj": "flyoutSubHeaderBackButton",
    iconType: "arrowLeft",
    size: "xs",
    href: (_backButtonProps$href = backButtonProps === null || backButtonProps === void 0 ? void 0 : backButtonProps.href) !== null && _backButtonProps$href !== void 0 ? _backButtonProps$href : '',
    onClick: backButtonProps === null || backButtonProps === void 0 ? void 0 : backButtonProps.onClick,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 55,
      columnNumber: 9
    }
  }, backButtonProps === null || backButtonProps === void 0 ? void 0 : backButtonProps.title));
});
BackToEndpointDetailsFlyoutSubHeader.displayName = 'BackToEndpointDetailsFlyoutSubHeader';