"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useFetchPolicyData = void 0;
var _react = require("react");
var _lodash = require("lodash");
var _use_fetch_integration_policy_list = require("../../../hooks/policy/use_fetch_integration_policy_list");
var _use_bulk_fetch_fleet_integration_policies = require("../../../hooks/policy/use_bulk_fetch_fleet_integration_policies");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Hook for use in the PolicySelector component. It normalizes the retrieval of data between
 * just fetching the regular list of policies -OR- bulk retrieving a list of policy by IDs.
 *
 * The primary goal of this hook is to efficiently manage the display of selected policies, which
 * uses the Bulk Get Package Policies API from fleet which does not have support for pagination.
 */
const useFetchPolicyData = (queryOptions, selectedPolicyIds, mode) => {
  var _selectedPoliciesPagi;
  const selectedPoliciesPagination = (0, _react.useMemo)(() => {
    if (mode === 'selected-list') {
      var _queryOptions$perPage;
      return (0, _lodash.chunk)(selectedPolicyIds, (_queryOptions$perPage = queryOptions === null || queryOptions === void 0 ? void 0 : queryOptions.perPage) !== null && _queryOptions$perPage !== void 0 ? _queryOptions$perPage : 20);
    }
    return [];
  }, [mode, queryOptions === null || queryOptions === void 0 ? void 0 : queryOptions.perPage, selectedPolicyIds]);
  const bulkFetchPage = (0, _react.useMemo)(() => {
    return selectedPoliciesPagination[queryOptions.page - 1] ? queryOptions.page : 1;
  }, [queryOptions.page, selectedPoliciesPagination]);
  const fetchListResult = (0, _use_fetch_integration_policy_list.useFetchIntegrationPolicyList)(queryOptions, {
    keepPreviousData: true,
    enabled: mode === 'full-list'
  });
  const bulkFetchResult = (0, _use_bulk_fetch_fleet_integration_policies.useBulkFetchFleetIntegrationPolicies)({
    ids: (_selectedPoliciesPagi = selectedPoliciesPagination[bulkFetchPage - 1]) !== null && _selectedPoliciesPagi !== void 0 ? _selectedPoliciesPagi : []
  }, {
    keepPreviousData: true,
    enabled: mode === 'selected-list'
  });
  return (0, _react.useMemo)(() => {
    if (mode === 'selected-list') {
      var _queryOptions$perPage2;
      return {
        data: bulkFetchResult.data ? {
          items: bulkFetchResult.data.items,
          total: selectedPolicyIds.length,
          perPage: (_queryOptions$perPage2 = queryOptions.perPage) !== null && _queryOptions$perPage2 !== void 0 ? _queryOptions$perPage2 : 20,
          page: bulkFetchPage
        } : undefined,
        isFetching: bulkFetchResult.isFetching,
        isLoading: bulkFetchResult.isLoading,
        error: bulkFetchResult.error
      };
    }
    return {
      data: fetchListResult.data,
      isFetching: fetchListResult.isFetching,
      isLoading: fetchListResult.isLoading,
      error: fetchListResult.error
    };
  }, [bulkFetchPage, bulkFetchResult.data, bulkFetchResult.error, bulkFetchResult.isFetching, bulkFetchResult.isLoading, fetchListResult.data, fetchListResult.error, fetchListResult.isFetching, fetchListResult.isLoading, mode, queryOptions.perPage, selectedPolicyIds.length]);
};
exports.useFetchPolicyData = useFetchPolicyData;