"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PolicyResponseArtifactItem = void 0;
var _react = _interopRequireWildcard(require("react"));
var _lodash = require("lodash");
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761322521701505730/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/management/components/policy_response/policy_response_artifact_item.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const StyledArtifactName = (0, _styledComponents.default)(_eui.EuiText)`
  white-space: nowrap;
  line-height: inherit;
  overflow: hidden;
  text-overflow: ellipsis;
`;
const StyledShaValue = (0, _styledComponents.default)(_eui.EuiText)`
  width: 80px;
  white-space: nowrap;
  line-height: inherit;
  overflow: hidden;
  text-overflow: ellipsis;
`;
const IconContainer = (0, _styledComponents.default)(_eui.EuiText)`
  padding: 2px;
  border: ${({
  theme
}) => theme.eui.euiBorderThin};
  border-radius: ${({
  theme
}) => theme.eui.euiBorderRadiusSmall};
`;
const COPY_TOOLTIP = {
  BEFORE: _i18n.i18n.translate('xpack.securitySolution.endpoint.details.policyResponse.artifact.copyButton.beforeCopyTooltip', {
    defaultMessage: 'Copy artifact ID'
  }),
  AFTER: _i18n.i18n.translate('xpack.securitySolution.endpoint.details.policyResponse.artifact.copyButton.afterCopyTooltip', {
    defaultMessage: 'Artifact ID copied!'
  })
};
const PolicyResponseArtifactItem = exports.PolicyResponseArtifactItem = /*#__PURE__*/(0, _react.memo)(({
  artifact
}) => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row",
    alignItems: "center",
    justifyContent: "spaceBetween",
    css: {
      flexWrap: 'nowrap'
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 57,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: true,
    css: {
      alignItems: 'flex-start'
    },
    className: 'eui-textTruncate',
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 63,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    position: "top",
    content: artifact.name,
    anchorClassName: 'eui-textTruncate',
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 64,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(StyledArtifactName, {
    "data-test-subj": "endpointPolicyResponseArtifactName",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 65,
      columnNumber: 11
    }
  }, artifact.name))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 70,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row",
    alignItems: "center",
    justifyContent: "flexEnd",
    gutterSize: "s",
    css: {
      flexWrap: 'nowrap'
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 71,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 78,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(IconContainer, {
    size: 'xs',
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 79,
      columnNumber: 13
    }
  }, 'sha256')), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 81,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(StyledShaValue, {
    "data-test-subj": "endpointPolicyResponseArtifactSha256",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 82,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    position: "top",
    content: artifact.sha256,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 83,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement("span", {
    tabIndex: 0,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 84,
      columnNumber: 17
    }
  }, (0, _lodash.truncate)(artifact.sha256, {
    length: 12
  }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    css: {
      marginTop: '-4px'
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 88,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCopy, {
    textToCopy: artifact.sha256,
    beforeMessage: COPY_TOOLTIP.BEFORE,
    afterMessage: COPY_TOOLTIP.AFTER,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 89,
      columnNumber: 13
    }
  }, copy => /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    size: "m",
    color: "primary",
    type: "copyClipboard",
    onClick: copy,
    "data-test-subj": "endpointPolicyResponseArtifactCopyButton",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 95,
      columnNumber: 17
    }
  }))))));
});
PolicyResponseArtifactItem.displayName = 'PolicyResponseArtifactItem';