"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PaginatedContent = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _i18nReact = require("@kbn/i18n-react");
var _uuid = require("uuid");
var _use_test_id_generator = require("../../hooks/use_test_id_generator");
var _constants = require("../../common/constants");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761322521701505730/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/management/components/paginated_content/paginated_content.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
// eslint-disable-next-line @typescript-eslint/no-explicit-any

// Using `memo()` on generic typed Functional component is not supported (generic is lost),
// Work around below was created based on this discussion:
// https://github.com/DefinitelyTyped/DefinitelyTyped/issues/37087#issuecomment-568218789

const RootContainer = _styledComponents.default.div`
  position: relative;
  padding-top: ${({
  theme
}) => theme.eui.euiSizeXS};

  .body {
    min-height: ${({
  theme
}) => theme.eui.euiSizeXXL};

    &-content {
      position: relative;
    }
  }
`;
const DefaultNoItemsFound = /*#__PURE__*/(0, _react.memo)(({
  'data-test-subj': dataTestSubj
}) => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
    "data-test-subj": dataTestSubj,
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.endpoint.paginatedContent.noItemsFoundTitle",
      defaultMessage: "No items found",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 99,
        columnNumber: 11
      }
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 96,
      columnNumber: 7
    }
  });
});
DefaultNoItemsFound.displayName = 'DefaultNoItemsFound';
const ErrorMessage = /*#__PURE__*/(0, _react.memo)(({
  message,
  'data-test-subj': dataTestSubj
}) => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    textAlign: "center",
    "data-test-subj": dataTestSubj,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 114,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 115,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: "minusInCircle",
    color: "danger",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 116,
      columnNumber: 9
    }
  }), " ", message, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 117,
      columnNumber: 9
    }
  }));
});
ErrorMessage.displayName = 'ErrorMessage';

/**
 * A generic component to display paginated content. Provides "Items per Page" as well as pagination
 * controls similar to the BasicTable of EUI. The props supported by this component (for the most part)
 * support those that BasicTable accept.
 */
const PaginatedContent = exports.PaginatedContent = /*#__PURE__*/(0, _react.memo)(({
  items,
  ItemComponent,
  itemComponentProps,
  itemId,
  onChange,
  pagination,
  loading,
  noItemsMessage,
  error,
  contentClassName,
  'data-test-subj': dataTestSubj,
  'aria-label': ariaLabel,
  className,
  CardDecorator,
  children
}) => {
  const [itemKeys] = (0, _react.useState)(new WeakMap());
  const getTestId = (0, _use_test_id_generator.useTestIdGenerator)(dataTestSubj);
  const pageCount = (0, _react.useMemo)(() => Math.ceil(((pagination === null || pagination === void 0 ? void 0 : pagination.totalItemCount) || 1) / ((pagination === null || pagination === void 0 ? void 0 : pagination.pageSize) || 1)), [pagination === null || pagination === void 0 ? void 0 : pagination.pageSize, pagination === null || pagination === void 0 ? void 0 : pagination.totalItemCount]);

  // If loading is done,
  // then check to ensure the pagination numbers are correct based by ensuring that the
  // `pageIndex` is not higher than the number of available pages.
  (0, _react.useEffect)(() => {
    if (!loading && pageCount > 0 && pageCount < ((pagination === null || pagination === void 0 ? void 0 : pagination.pageIndex) || 0) + 1) {
      onChange({
        pageIndex: pageCount - 1,
        pageSize: (pagination === null || pagination === void 0 ? void 0 : pagination.pageSize) || 0
      });
    }
  }, [pageCount, onChange, pagination, loading]);
  const handleItemsPerPageChange = (0, _react.useCallback)(pageSize => {
    if (pagination !== null && pagination !== void 0 && pagination.pageIndex) {
      var _pagination$pageIndex, _pagination$pageSize;
      const pageIndex = Math.floor(((_pagination$pageIndex = pagination === null || pagination === void 0 ? void 0 : pagination.pageIndex) !== null && _pagination$pageIndex !== void 0 ? _pagination$pageIndex : _constants.MANAGEMENT_DEFAULT_PAGE) * ((_pagination$pageSize = pagination === null || pagination === void 0 ? void 0 : pagination.pageSize) !== null && _pagination$pageSize !== void 0 ? _pagination$pageSize : _constants.MANAGEMENT_DEFAULT_PAGE_SIZE) / pageSize);
      onChange({
        pageSize,
        pageIndex: isNaN(pageIndex) ? _constants.MANAGEMENT_DEFAULT_PAGE : pageIndex
      });
    } else {
      onChange({
        pageSize,
        pageIndex: _constants.MANAGEMENT_DEFAULT_PAGE
      });
    }
  }, [onChange, pagination]);
  const handlePageChange = (0, _react.useCallback)(pageIndex => {
    onChange({
      pageIndex,
      pageSize: (pagination === null || pagination === void 0 ? void 0 : pagination.pageSize) || _constants.MANAGEMENT_DEFAULT_PAGE_SIZE
    });
  }, [onChange, pagination === null || pagination === void 0 ? void 0 : pagination.pageSize]);
  const generatedBodyItemContent = (0, _react.useMemo)(() => {
    if (error) {
      if (error instanceof Error) {
        return /*#__PURE__*/_react.default.createElement(ErrorMessage, {
          message: error.message,
          "data-test-subj": getTestId('error'),
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 197,
            columnNumber: 18
          }
        });
      }
      return 'string' === typeof error ? /*#__PURE__*/_react.default.createElement(ErrorMessage, {
        message: error,
        "data-test-subj": getTestId('error'),
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 200,
          columnNumber: 11
        }
      }) : error;
    }

    // This casting here is needed in order to avoid the following a TS error (TS2322)
    // stating that the attributes given to the `ItemComponent` are not assignable to
    // type 'LibraryManagedAttributes<C, any>'
    // @see https://github.com/DefinitelyTyped/DefinitelyTyped/issues/34553
    const Item = ItemComponent;
    if (items.length) {
      // Cast here is to get around the fact that TS does not seem to be able to narrow the types down when the only
      // difference is that the array might be Readonly. The error output is:
      // `...has signatures, but none of those signatures are compatible with each other.`
      // Can read more about it here: https://github.com/microsoft/TypeScript/issues/33591
      return items.map(item => {
        let key;
        if (itemId) {
          key = item[itemId];
        } else {
          if (itemKeys.has(item)) {
            // eslint-disable-next-line @typescript-eslint/no-non-null-assertion
            key = itemKeys.get(item);
          } else {
            key = (0, _uuid.v4)();
            itemKeys.set(item, key);
          }
        }
        return /*#__PURE__*/_react.default.createElement(Item, (0, _extends2.default)({}, itemComponentProps(item), {
          key: key,
          Decorator: CardDecorator,
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 232,
            columnNumber: 18
          }
        }));
      });
    }
    if (!loading) return noItemsMessage || /*#__PURE__*/_react.default.createElement(DefaultNoItemsFound, {
      "data-test-subj": getTestId('noResults'),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 236,
        columnNumber: 34
      }
    });
  }, [error, ItemComponent, items, loading, noItemsMessage, getTestId, itemId, itemComponentProps, CardDecorator, itemKeys]);
  return /*#__PURE__*/_react.default.createElement(RootContainer, {
    "data-test-subj": dataTestSubj,
    "aria-label": ariaLabel,
    className: className,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 251,
      columnNumber: 7
    }
  }, loading && /*#__PURE__*/_react.default.createElement(_eui.EuiProgress, {
    size: "xs",
    color: "primary",
    position: "absolute",
    "data-test-subj": getTestId('loader'),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 253,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement("div", {
    className: "body",
    "data-test-subj": getTestId('body'),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 261,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement("div", {
    className: `body-content ${contentClassName}`,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 262,
      columnNumber: 11
    }
  }, children ? children : generatedBodyItemContent)), pagination && (children || items.length > 0) && /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": getTestId('footer'),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 268,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 269,
      columnNumber: 13
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiTablePagination, {
    activePage: pagination.pageIndex,
    itemsPerPage: pagination.pageSize,
    itemsPerPageOptions: pagination.pageSizeOptions,
    pageCount: pageCount,
    showPerPageOptions: pagination.showPerPageOptions,
    onChangeItemsPerPage: handleItemsPerPageChange,
    onChangePage: handlePageChange,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 271,
      columnNumber: 13
    }
  })));
}
// See type description above to understand why this casting is needed
);
PaginatedContent.displayName = 'PaginatedContent';