"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ActionsLogFilters = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _use_experimental_features = require("../../../../common/hooks/use_experimental_features");
var _actions_log_date_range_picker = require("./actions_log_date_range_picker");
var _actions_log_filter = require("./actions_log_filter");
var _actions_log_users_filter = require("./actions_log_users_filter");
var _use_test_id_generator = require("../../../hooks/use_test_id_generator");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761322521701505730/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/management/components/endpoint_response_actions_list/components/actions_log_filters.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const ActionsLogFilters = exports.ActionsLogFilters = /*#__PURE__*/(0, _react.memo)(({
  dateRangePickerState,
  isDataLoading,
  isFlyout,
  onClick,
  onChangeAgentTypesFilter,
  onChangeHostsFilter,
  onChangeCommandsFilter,
  onChangeStatusesFilter,
  onChangeUsersFilter,
  onChangeTypeFilter,
  onRefresh,
  onRefreshChange,
  onTimeChange,
  showHostsFilter,
  'data-test-subj': dataTestSubj,
  'data-test-height': dataTestHeight
}) => {
  const getTestId = (0, _use_test_id_generator.useTestIdGenerator)(dataTestSubj);
  const isSentinelOneV1Enabled = (0, _use_experimental_features.useIsExperimentalFeatureEnabled)('responseActionsSentinelOneV1Enabled');
  const filters = (0, _react.useMemo)(() => {
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, showHostsFilter && /*#__PURE__*/_react.default.createElement(_actions_log_filter.ActionsLogFilter, {
      filterName: 'hosts',
      isFlyout: isFlyout,
      onChangeFilterOptions: onChangeHostsFilter,
      "data-test-subj": dataTestSubj,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 69,
        columnNumber: 13
      }
    }), /*#__PURE__*/_react.default.createElement(_actions_log_filter.ActionsLogFilter, {
      filterName: 'actions',
      isFlyout: isFlyout,
      onChangeFilterOptions: onChangeCommandsFilter,
      "data-test-subj": dataTestSubj,
      "data-test-height": dataTestHeight,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 76,
        columnNumber: 11
      }
    }), /*#__PURE__*/_react.default.createElement(_actions_log_filter.ActionsLogFilter, {
      filterName: 'statuses',
      isFlyout: isFlyout,
      onChangeFilterOptions: onChangeStatusesFilter,
      "data-test-subj": dataTestSubj,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 83,
        columnNumber: 11
      }
    }), isSentinelOneV1Enabled ? /*#__PURE__*/_react.default.createElement(_actions_log_filter.ActionsLogFilter, {
      filterName: 'types',
      typesFilters: {
        agentTypes: {
          onChangeFilterOptions: onChangeAgentTypesFilter
        },
        actionTypes: {
          onChangeFilterOptions: onChangeTypeFilter
        }
      },
      isFlyout: isFlyout,
      "data-test-subj": dataTestSubj,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 90,
        columnNumber: 13
      }
    }) : /*#__PURE__*/_react.default.createElement(_actions_log_filter.ActionsLogFilter, {
      filterName: 'types',
      onChangeFilterOptions: onChangeTypeFilter,
      isFlyout: isFlyout,
      "data-test-subj": dataTestSubj,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 100,
        columnNumber: 13
      }
    }));
  }, [showHostsFilter, isFlyout, isSentinelOneV1Enabled, onChangeHostsFilter, dataTestSubj, dataTestHeight, onChangeCommandsFilter, onChangeStatusesFilter, onChangeAgentTypesFilter, onChangeTypeFilter]);
  const onClickRefreshButton = (0, _react.useCallback)(() => onClick(), [onClick]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    responsive: true,
    gutterSize: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 125,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: isFlyout ? 1 : 2,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 126,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_actions_log_users_filter.ActionsLogUsersFilter, {
    isFlyout: isFlyout,
    onChangeUsersFilter: onChangeUsersFilter,
    "data-test-subj": dataTestSubj,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 127,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: isFlyout ? 1 : 1,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 133,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFilterGroup, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 134,
      columnNumber: 11
    }
  }, filters)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: isFlyout ? 1 : 2,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 136,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_actions_log_date_range_picker.ActionLogDateRangePicker, {
    dateRangePickerState: dateRangePickerState,
    isDataLoading: isDataLoading,
    onRefresh: onRefresh,
    onRefreshChange: onRefreshChange,
    onTimeChange: onTimeChange,
    "data-test-subj": dataTestSubj,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 137,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 146,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSuperUpdateButton, {
    iconOnly: true,
    "data-test-subj": getTestId('super-refresh-button'),
    fill: false,
    isLoading: isDataLoading,
    onClick: onClickRefreshButton,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 147,
      columnNumber: 11
    }
  })));
});
ActionsLogFilters.displayName = 'ActionsLogFilters';