"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SidePanelContentManager = void 0;
var _react = _interopRequireWildcard(require("react"));
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _use_test_id_generator = require("../../../../hooks/use_test_id_generator");
var _command_list = require("../command_list");
var _use_with_command_list = require("../../hooks/state_selectors/use_with_command_list");
var _side_panel_content_layout = require("./side_panel_content_layout");
var _use_with_side_panel = require("../../hooks/state_selectors/use_with_side_panel");
var _use_console_state_dispatch = require("../../hooks/state_selectors/use_console_state_dispatch");
var _use_data_test_subj = require("../../hooks/state_selectors/use_data_test_subj");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761322521701505730/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/management/components/console/components/side_panel/side_panel_content_manager.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const StyledEuiFlexGroup = (0, _styledComponents.default)(_eui.EuiFlexGroup)`
  padding-top: ${({
  theme: {
    eui
  }
}) => eui.euiPanelPaddingModifiers.paddingSmall};
  padding-right: ${({
  theme: {
    eui
  }
}) => eui.euiPanelPaddingModifiers.paddingSmall};
`;
const SidePanelContentManager = exports.SidePanelContentManager = /*#__PURE__*/(0, _react.memo)(() => {
  const dispatch = (0, _use_console_state_dispatch.useConsoleStateDispatch)();
  const commands = (0, _use_with_command_list.useWithCommandList)();
  const getTestId = (0, _use_test_id_generator.useTestIdGenerator)((0, _use_data_test_subj.useDataTestSubj)('sidePanel'));
  const show = (0, _use_with_side_panel.useWithSidePanel)().show;
  const closeHelpPanel = (0, _react.useCallback)(() => {
    dispatch({
      type: 'showSidePanel',
      payload: {
        show: null
      }
    });
  }, [dispatch]);
  const panelHeader = (0, _react.useMemo)(() => {
    if (show === 'help') {
      return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(StyledEuiFlexGroup, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 52,
          columnNumber: 11
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 53,
          columnNumber: 13
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
        size: "s",
        "data-test-subj": getTestId('headerTitle'),
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 54,
          columnNumber: 15
        }
      }, /*#__PURE__*/_react.default.createElement("h3", {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 55,
          columnNumber: 17
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.securitySolution.console.sidePanel.helpTitle",
        defaultMessage: "Help",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 56,
          columnNumber: 19
        }
      })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 63,
          columnNumber: 13
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
        "aria-label": "closeSidePanelIcon",
        iconType: "cross",
        color: "text",
        onClick: closeHelpPanel,
        "data-test-subj": getTestId('headerCloseButton'),
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 64,
          columnNumber: 15
        }
      }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
        size: "m",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 73,
          columnNumber: 11
        }
      }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        size: "s",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 74,
          columnNumber: 11
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.securitySolution.console.sidePanel.helpDescription",
        defaultMessage: "Use the add ({icon}) button to populate a response action to the text bar. Add additional parameters or comments as necessary.",
        values: {
          icon: /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
            type: "plusInCircle",
            __self: void 0,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 79,
              columnNumber: 23
            }
          })
        },
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 75,
          columnNumber: 13
        }
      })));
    }
    return null;
  }, [show, getTestId, closeHelpPanel]);
  const panelBody = (0, _react.useMemo)(() => {
    if (show === 'help') {
      return /*#__PURE__*/_react.default.createElement("div", {
        "data-test-subj": getTestId('helpContent'),
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 92,
          columnNumber: 9
        }
      }, /*#__PURE__*/_react.default.createElement(_command_list.CommandList, {
        commands: commands,
        display: "table",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 93,
          columnNumber: 11
        }
      }));
    }
    return null;
  }, [commands, getTestId, show]);
  if (!show) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_side_panel_content_layout.SidePanelContentLayout, {
    headerContent: panelHeader,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 105,
      columnNumber: 10
    }
  }, panelBody);
});
SidePanelContentManager.displayName = 'RightPanelContentManager';