"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SidePanelContentLayout = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _use_test_id_generator = require("../../../../hooks/use_test_id_generator");
var _use_data_test_subj = require("../../hooks/state_selectors/use_data_test_subj");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761322521701505730/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/management/components/console/components/side_panel/side_panel_content_layout.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const StyledEuiFlexItemNoPadding = (0, _styledComponents.default)(_eui.EuiFlexItem)`
  padding: 0 !important;
`;

/**
 * A layout component for displaying content in the right-side panel of the console
 */
const SidePanelContentLayout = exports.SidePanelContentLayout = /*#__PURE__*/(0, _react.memo)(({
  headerContent,
  children
}) => {
  const getTestId = (0, _use_test_id_generator.useTestIdGenerator)((0, _use_data_test_subj.useDataTestSubj)('sidePanel'));
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    responsive: false,
    className: "eui-fullHeight",
    gutterSize: "none",
    "data-test-subj": getTestId(),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 32,
      columnNumber: 7
    }
  }, headerContent && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    className: "layout-container",
    "data-test-subj": getTestId('header'),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 41,
      columnNumber: 13
    }
  }, headerContent), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "none",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 48,
      columnNumber: 13
    }
  })), /*#__PURE__*/_react.default.createElement(StyledEuiFlexItemNoPadding, {
    className: "eui-scrollBar eui-yScroll layout-container",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 51,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": getTestId('body'),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 52,
      columnNumber: 11
    }
  }, children)));
});
SidePanelContentLayout.displayName = 'SidePanelContentLayout';