"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useMarkInsightAsRemediated = void 0;
var _reactQuery = require("@tanstack/react-query");
var _translations = require("../../../pages/endpoint_hosts/view/translations");
var _workflow_insights = require("../../../../../common/endpoint/types/workflow_insights");
var _resolve_path_variables = require("../../../../common/utils/resolve_path_variables");
var _constants = require("../../../../../common/endpoint/constants");
var _kibana = require("../../../../common/lib/kibana");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useMarkInsightAsRemediated = backUrl => {
  const toasts = (0, _kibana.useToasts)();
  const {
    application: {
      navigateToUrl
    },
    http
  } = (0, _kibana.useKibana)().services;
  return (0, _reactQuery.useMutation)(({
    insightId
  }) => http.put((0, _resolve_path_variables.resolvePathVariables)(_constants.WORKFLOW_INSIGHTS_UPDATE_ROUTE, {
    insightId
  }), {
    version: '1',
    body: JSON.stringify({
      action: {
        type: _workflow_insights.ActionType.Remediated
      }
    })
  }), {
    onError: err => {
      toasts.addDanger({
        title: _translations.WORKFLOW_INSIGHTS.toasts.updateInsightError,
        text: err === null || err === void 0 ? void 0 : err.message
      });
    },
    onSuccess: () => {
      if (backUrl) return navigateToUrl(backUrl);
    }
  });
};
exports.useMarkInsightAsRemediated = useMarkInsightAsRemediated;