"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useKueryFromExceptionsSearchFilter = void 0;
var _react = require("react");
var _utils = require("../../../common/utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useKueryFromExceptionsSearchFilter = (filter, fields, policies) => {
  return (0, _react.useMemo)(() => {
    return (0, _utils.parsePoliciesAndFilterToKql)({
      kuery: (0, _utils.parseQueryFilterToKQL)(filter, fields),
      policies: policies ? policies.split(',') : []
    });
  }, [fields, filter, policies]);
};
exports.useKueryFromExceptionsSearchFilter = useKueryFromExceptionsSearchFilter;