"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useIsArtifactAllowedPerPolicyUsage = void 0;
var _react = require("react");
var _user_privileges = require("../../../../common/components/user_privileges");
var _artifacts = require("../../../../../common/endpoint/service/artifacts");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useIsArtifactAllowedPerPolicyUsage = (item, mode) => {
  const endpointAuthz = (0, _user_privileges.useUserPrivileges)().endpointPrivileges;
  return (0, _react.useMemo)(() => {
    return mode === 'edit' && !endpointAuthz.canCreateArtifactsByPolicy && (0, _artifacts.isArtifactByPolicy)(item);
  }, [endpointAuthz.canCreateArtifactsByPolicy, item, mode]);
};
exports.useIsArtifactAllowedPerPolicyUsage = useIsArtifactAllowedPerPolicyUsage;