"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useCollapsedCssClassNames = void 0;
var _react = require("react");
var _classnames = _interopRequireDefault(require("classnames"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Returns the css classnames that should be applied when the collapsible card is NOT expanded
 * @param expanded
 */
const useCollapsedCssClassNames = expanded => {
  return (0, _react.useMemo)(() => {
    return (0, _classnames.default)({
      'eui-textTruncate': !expanded
    });
  }, [expanded]);
};
exports.useCollapsedCssClassNames = useCollapsedCssClassNames;