"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useHighlightedFields = void 0;
var _fp = require("lodash/fp");
var _ruleDataUtils = require("@kbn/rule-data-utils");
var _use_alert_response_actions_support = require("../../../../common/hooks/endpoint/use_alert_response_actions_support");
var _endpoint = require("../../../../common/lib/endpoint");
var _get_alert_summary_rows = require("../../../../common/components/event_details/get_alert_summary_rows");
var _constants = require("../../../../timelines/components/timeline/body/renderers/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Returns the highlighted fields to display in the right panel under the Investigation section.
 */
const useHighlightedFields = ({
  dataFormattedForFieldBrowser,
  investigationFields,
  type
}) => {
  var _eventCodeField$origi, _eventRuleTypeField$o;
  const responseActionsSupport = (0, _use_alert_response_actions_support.useAlertResponseActionsSupport)(dataFormattedForFieldBrowser);
  const eventCategories = (0, _get_alert_summary_rows.getEventCategoriesFromData)(dataFormattedForFieldBrowser);
  const eventCodeField = (0, _fp.find)({
    category: 'event',
    field: 'event.code'
  }, dataFormattedForFieldBrowser);
  const eventCode = Array.isArray(eventCodeField === null || eventCodeField === void 0 ? void 0 : eventCodeField.originalValue) ? eventCodeField === null || eventCodeField === void 0 ? void 0 : (_eventCodeField$origi = eventCodeField.originalValue) === null || _eventCodeField$origi === void 0 ? void 0 : _eventCodeField$origi[0] : eventCodeField === null || eventCodeField === void 0 ? void 0 : eventCodeField.originalValue;
  const eventRuleTypeField = (0, _fp.find)({
    category: 'kibana',
    field: _ruleDataUtils.ALERT_RULE_TYPE
  }, dataFormattedForFieldBrowser);
  const eventRuleType = Array.isArray(eventRuleTypeField === null || eventRuleTypeField === void 0 ? void 0 : eventRuleTypeField.originalValue) ? eventRuleTypeField === null || eventRuleTypeField === void 0 ? void 0 : (_eventRuleTypeField$o = eventRuleTypeField.originalValue) === null || _eventRuleTypeField$o === void 0 ? void 0 : _eventRuleTypeField$o[0] : eventRuleTypeField === null || eventRuleTypeField === void 0 ? void 0 : eventRuleTypeField.originalValue;
  const tableFields = (0, _get_alert_summary_rows.getHighlightedFieldsToDisplay)({
    eventCategories,
    eventCode,
    eventRuleType,
    ruleCustomHighlightedFields: investigationFields,
    type
  });
  return tableFields.reduce((acc, field) => {
    var _find$values, _find;
    const item = dataFormattedForFieldBrowser.find(data => data.field === field.id || field.legacyId && data.field === field.legacyId);
    if (!item) {
      return acc;
    }

    // if there aren't any values we can skip this highlighted field
    let fieldValues = item.values;
    if (!fieldValues || (0, _fp.isEmpty)(fieldValues)) {
      return acc;
    }

    // if we found the data by its legacy id we swap the ids to display the correct one
    if (item.field === field.legacyId) {
      field.id = field.legacyId;
    }

    // If the field is one used by a supported Response Actions agentType,
    // but the alert field is not the one that the agentType on the alert host uses,
    // then exit and return accumulator
    if ((0, _endpoint.isResponseActionsAlertAgentIdField)(field.id) && responseActionsSupport.details.agentIdField !== field.id) {
      return acc;
    }

    /**
     * Source event use-case.
     * In this case we only want to show ancestors of level "0".
     * We can obtain those by using the `kibana.alert.ancestors.depth` field
     */
    if (item.field === _constants.EVENT_SOURCE_FIELD_NAME) {
      const depts = dataFormattedForFieldBrowser.find(_item => _item.field === `kibana.alert.ancestors.depth`);
      fieldValues = fieldValues.filter((_, idx) => {
        var _depts$values$idx, _depts$values;
        return ((_depts$values$idx = depts === null || depts === void 0 ? void 0 : (_depts$values = depts.values) === null || _depts$values === void 0 ? void 0 : _depts$values[idx]) !== null && _depts$values$idx !== void 0 ? _depts$values$idx : '0') === '0';
      });
    }
    return {
      ...acc,
      [field.id]: {
        ...(field.overrideField && {
          overrideField: {
            field: field.overrideField,
            values: (_find$values = (_find = (0, _fp.find)({
              field: field.overrideField
            }, dataFormattedForFieldBrowser)) === null || _find === void 0 ? void 0 : _find.values) !== null && _find$values !== void 0 ? _find$values : []
          }
        }),
        values: fieldValues
      }
    };
  }, {});
};
exports.useHighlightedFields = useHighlightedFields;