"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useAlertDocumentAnalyzerSchema = useAlertDocumentAnalyzerSchema;
var _reactQuery = require("@tanstack/react-query");
var _kibana = require("../../../../common/lib/kibana");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function useAlertDocumentAnalyzerSchema({
  documentId,
  indices
}) {
  const http = (0, _kibana.useHttp)();
  const query = (0, _reactQuery.useQuery)(['getAlertPrevalenceSchema', documentId], () => {
    return http.get(`/api/endpoint/resolver/entity`, {
      query: {
        _id: documentId,
        indices
      }
    });
  });
  if (query.isLoading) {
    return {
      loading: true,
      error: false,
      id: null,
      schema: null,
      agentId: null
    };
  } else if (query.data && query.data.length > 0) {
    const {
      data: [{
        schema,
        id,
        agentId
      }]
    } = query;
    return {
      loading: false,
      error: false,
      id,
      schema,
      agentId
    };
  } else {
    return {
      loading: false,
      error: true,
      id: null,
      schema: null,
      agentId: null
    };
  }
}