"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.InsightsTab = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _expandableFlyout = require("@kbn/expandable-flyout");
var _kibana = require("../../../../common/lib/kibana");
var _test_ids = require("./test_ids");
var _context = require("../../shared/context");
var _panel_keys = require("../../shared/constants/panel_keys");
var _ = require("..");
var _entities_details = require("../components/entities_details");
var _threat_intelligence_details = require("../components/threat_intelligence_details");
var _prevalence_details = require("../components/prevalence_details");
var _correlations_details = require("../components/correlations_details");
var _utils = require("../../shared/utils");
var _event_kinds = require("../../shared/constants/event_kinds");
var _telemetry = require("../../../../common/lib/telemetry");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761322521701505730/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/flyout/document_details/left/tabs/insights_tab.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const ENTITIES_TAB_ID = 'entity';
const insightsButtons = [{
  id: ENTITIES_TAB_ID,
  label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.flyout.left.insights.entitiesButtonLabel",
    defaultMessage: "Entities",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 42,
      columnNumber: 7
    }
  }),
  'data-test-subj': _test_ids.INSIGHTS_TAB_ENTITIES_BUTTON_TEST_ID
}, {
  id: _threat_intelligence_details.THREAT_INTELLIGENCE_TAB_ID,
  label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.flyout.left.insights.threatIntelligenceButtonLabel",
    defaultMessage: "Threat intelligence",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 52,
      columnNumber: 7
    }
  }),
  'data-test-subj': _test_ids.INSIGHTS_TAB_THREAT_INTELLIGENCE_BUTTON_TEST_ID
}, {
  id: _prevalence_details.PREVALENCE_TAB_ID,
  label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.flyout.left.insights.prevalenceButtonLabel",
    defaultMessage: "Prevalence",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 62,
      columnNumber: 7
    }
  }),
  'data-test-subj': _test_ids.INSIGHTS_TAB_PREVALENCE_BUTTON_TEST_ID
}, {
  id: _correlations_details.CORRELATIONS_TAB_ID,
  label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.flyout.left.insights.correlationsButtonLabel",
    defaultMessage: "Correlations",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 72,
      columnNumber: 7
    }
  }),
  'data-test-subj': _test_ids.INSIGHTS_TAB_CORRELATIONS_BUTTON_TEST_ID
}];

/**
 * Insights view displayed in the document details expandable flyout left section
 */
const InsightsTab = exports.InsightsTab = /*#__PURE__*/(0, _react.memo)(() => {
  var _panels$left$path$sub, _panels$left, _panels$left$path;
  const {
    telemetry
  } = (0, _kibana.useKibana)().services;
  const {
    eventId,
    indexName,
    scopeId,
    getFieldsData
  } = (0, _context.useDocumentDetailsContext)();
  const isEventKindSignal = (0, _utils.getField)(getFieldsData('event.kind')) === _event_kinds.EventKind.signal;
  const {
    openLeftPanel
  } = (0, _expandableFlyout.useExpandableFlyoutApi)();
  const panels = (0, _expandableFlyout.useExpandableFlyoutState)();
  const activeInsightsId = (_panels$left$path$sub = (_panels$left = panels.left) === null || _panels$left === void 0 ? void 0 : (_panels$left$path = _panels$left.path) === null || _panels$left$path === void 0 ? void 0 : _panels$left$path.subTab) !== null && _panels$left$path$sub !== void 0 ? _panels$left$path$sub : ENTITIES_TAB_ID;

  // insight tabs based on whether document is alert or non-alert
  // alert: entities, threat intelligence, prevalence, correlations
  // non-alert: entities, prevalence, correlations
  const buttonGroup = (0, _react.useMemo)(() => isEventKindSignal ? insightsButtons : insightsButtons.filter(tab => tab.id !== _threat_intelligence_details.THREAT_INTELLIGENCE_TAB_ID), [isEventKindSignal]);
  const onChangeCompressed = (0, _react.useCallback)(optionId => {
    openLeftPanel({
      id: _panel_keys.DocumentDetailsLeftPanelKey,
      path: {
        tab: _.LeftPanelInsightsTab,
        subTab: optionId
      },
      params: {
        id: eventId,
        indexName,
        scopeId
      }
    });
    telemetry.reportEvent(_telemetry.DocumentEventTypes.DetailsFlyoutTabClicked, {
      location: scopeId,
      panel: 'left',
      tabId: optionId
    });
  }, [eventId, indexName, scopeId, openLeftPanel, telemetry]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonGroup, {
    color: "primary",
    legend: _i18n.i18n.translate('xpack.securitySolution.flyout.left.insights.buttonGroupLegendLabel', {
      defaultMessage: 'Insights options'
    }),
    options: buttonGroup,
    idSelected: activeInsightsId,
    onChange: onChangeCompressed,
    buttonSize: "compressed",
    isFullWidth: true,
    "data-test-subj": _test_ids.INSIGHTS_TAB_BUTTON_GROUP_TEST_ID,
    style: !isEventKindSignal ? {
      maxWidth: 450
    } : undefined,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 128,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 142,
      columnNumber: 7
    }
  }), activeInsightsId === ENTITIES_TAB_ID && /*#__PURE__*/_react.default.createElement(_entities_details.EntitiesDetails, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 143,
      columnNumber: 48
    }
  }), activeInsightsId === _threat_intelligence_details.THREAT_INTELLIGENCE_TAB_ID && /*#__PURE__*/_react.default.createElement(_threat_intelligence_details.ThreatIntelligenceDetails, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 144,
      columnNumber: 59
    }
  }), activeInsightsId === _prevalence_details.PREVALENCE_TAB_ID && /*#__PURE__*/_react.default.createElement(_prevalence_details.PrevalenceDetails, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 145,
      columnNumber: 50
    }
  }), activeInsightsId === _correlations_details.CORRELATIONS_TAB_ID && /*#__PURE__*/_react.default.createElement(_correlations_details.CorrelationsDetails, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 146,
      columnNumber: 52
    }
  }));
});
InsightsTab.displayName = 'InsightsTab';