"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AllUsersQueryTabBody = void 0;
var _fp = require("lodash/fp");
var _react = _interopRequireWildcard(require("react"));
var _manage_query = require("../../../../common/components/page/manage_query");
var _all_users = require("../../components/all_users");
var _use_search_strategy = require("../../../../common/containers/use_search_strategy");
var _users = require("../../../../../common/search_strategy/security_solution/users");
var i18n = _interopRequireWildcard(require("./translations"));
var _helpers = require("../../../components/paginated_table/helpers");
var _use_selector = require("../../../../common/hooks/use_selector");
var _store = require("../../store");
var _query_toggle = require("../../../../common/containers/query_toggle");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761322521701505730/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/explore/users/pages/navigation/all_users_query_tab_body.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const UsersTableManage = (0, _manage_query.manageQuery)(_all_users.UsersTable);
const QUERY_ID = 'UsersTable';
const AllUsersQueryTabBody = ({
  endDate,
  filterQuery,
  indexNames,
  skip,
  setQuery,
  startDate,
  type,
  deleteQuery
}) => {
  const {
    toggleStatus
  } = (0, _query_toggle.useQueryToggle)(QUERY_ID);
  const [querySkip, setQuerySkip] = (0, _react.useState)(skip || !toggleStatus);
  (0, _react.useEffect)(() => {
    setQuerySkip(skip || !toggleStatus);
  }, [skip, toggleStatus]);
  const getUsersSelector = (0, _react.useMemo)(() => _store.usersSelectors.allUsersSelector(), []);
  const {
    activePage,
    limit,
    sort
  } = (0, _use_selector.useDeepEqualSelector)(state => getUsersSelector(state));
  const {
    loading,
    result: {
      users,
      pageInfo,
      totalCount
    },
    search,
    refetch,
    inspect
  } = (0, _use_search_strategy.useSearchStrategy)({
    factoryQueryType: _users.UsersQueries.users,
    initialResult: {
      users: [],
      totalCount: 0,
      pageInfo: {
        activePage: 0,
        fakeTotalCount: 0,
        showMorePagesIndicator: false
      }
    },
    errorMessage: i18n.ERROR_FETCHING_USERS_DATA,
    abort: querySkip
  });
  (0, _react.useEffect)(() => {
    if (!querySkip) {
      search({
        filterQuery,
        defaultIndex: indexNames,
        timerange: {
          interval: '12h',
          from: startDate,
          to: endDate
        },
        pagination: (0, _helpers.generateTablePaginationOptions)(activePage, limit),
        sort
      });
    }
  }, [search, startDate, endDate, filterQuery, indexNames, querySkip, activePage, limit, sort]);
  return /*#__PURE__*/_react.default.createElement(UsersTableManage, {
    users: users,
    deleteQuery: deleteQuery,
    fakeTotalCount: (0, _fp.getOr)(50, 'fakeTotalCount', pageInfo),
    id: QUERY_ID,
    inspect: inspect,
    loading: loading,
    loadPage: _fp.noop // It isn't necessary because PaginatedTable updates redux store and we load the page when activePage updates on the store
    ,
    refetch: refetch,
    showMorePagesIndicator: (0, _fp.getOr)(false, 'showMorePagesIndicator', pageInfo),
    setQuery: setQuery,
    totalCount: totalCount,
    type: type,
    sort: sort,
    setQuerySkip: setQuerySkip,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 84,
      columnNumber: 5
    }
  });
};
exports.AllUsersQueryTabBody = AllUsersQueryTabBody;
AllUsersQueryTabBody.displayName = 'AllUsersQueryTabBody';