"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.USER_RISK = exports.USER_NAME = exports.USERS = exports.UNIT = exports.ROWS_5 = exports.ROWS_10 = exports.LAST_SEEN = exports.DOMAIN = exports.ASSET_CRITICALITY = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const USERS = exports.USERS = _i18n.i18n.translate('xpack.securitySolution.usersTable.title', {
  defaultMessage: 'Users'
});
const USER_NAME = exports.USER_NAME = _i18n.i18n.translate('xpack.securitySolution.usersTable.userNameTitle', {
  defaultMessage: 'User name'
});
const LAST_SEEN = exports.LAST_SEEN = _i18n.i18n.translate('xpack.securitySolution.usersTable.lastSeenTitle', {
  defaultMessage: 'Last seen'
});
const DOMAIN = exports.DOMAIN = _i18n.i18n.translate('xpack.securitySolution.usersTable.domainTitle', {
  defaultMessage: 'Domain'
});
const ROWS_5 = exports.ROWS_5 = _i18n.i18n.translate('xpack.securitySolution.usersTable.rows', {
  values: {
    numRows: 5
  },
  defaultMessage: '{numRows} {numRows, plural, =0 {rows} =1 {row} other {rows}}'
});
const ROWS_10 = exports.ROWS_10 = _i18n.i18n.translate('xpack.securitySolution.usersTable.rows', {
  values: {
    numRows: 10
  },
  defaultMessage: '{numRows} {numRows, plural, =0 {rows} =1 {row} other {rows}}'
});
const UNIT = totalCount => _i18n.i18n.translate('xpack.securitySolution.usersTable.unit', {
  values: {
    totalCount
  },
  defaultMessage: `{totalCount, plural, =1 {user} other {users}}`
});
exports.UNIT = UNIT;
const USER_RISK = exports.USER_RISK = _i18n.i18n.translate('xpack.securitySolution.usersTable.riskTitle', {
  defaultMessage: 'User risk level'
});
const ASSET_CRITICALITY = exports.ASSET_CRITICALITY = _i18n.i18n.translate('xpack.securitySolution.hostsTable.assetCriticality', {
  defaultMessage: 'Asset criticality'
});