"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.usersSelector = exports.topNFlowSelector = exports.topCountriesSelector = exports.tlsSelector = exports.networkAnomaliesJobIdFilterSelector = exports.networkAnomaliesIntervalSelector = exports.httpSelector = exports.dnsSelector = void 0;
var _reselect = require("reselect");
var _fp = require("lodash/fp");
var _network = require("../../../../common/search_strategy/security_solution/network");
var _reducer = require("./reducer");
var _model = require("./model");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const selectNetwork = (state, networkType) => (0, _fp.get)(networkType, state.network);
const selectNetworkPage = state => state.network.page;
const selectNetworkDetails = state => state.network.details;

// Network Page Selectors
const dnsSelector = () => (0, _reselect.createSelector)(selectNetworkPage, network => network.queries.dns);
exports.dnsSelector = dnsSelector;
const selectTopNFlowByType = (state, networkType, flowTarget) => {
  const ft = flowTarget === _network.FlowTargetSourceDest.source ? 'topNFlowSource' : 'topNFlowDestination';
  const nFlowType = networkType === _model.NetworkType.page ? _model.NetworkTableType[ft] : _model.NetworkDetailsTableType[ft];
  return (0, _fp.get)([networkType, 'queries', nFlowType], state.network) || (0, _fp.get)([networkType, 'queries', nFlowType], _reducer.initialNetworkState);
};
const topNFlowSelector = () => (0, _reselect.createSelector)(selectTopNFlowByType, topNFlowQueries => topNFlowQueries);
exports.topNFlowSelector = topNFlowSelector;
const selectTlsByType = (state, networkType) => {
  const tlsType = networkType === _model.NetworkType.page ? _model.NetworkTableType.tls : _model.NetworkDetailsTableType.tls;
  return (0, _fp.get)([networkType, 'queries', tlsType], state.network) || (0, _fp.get)([networkType, 'queries', tlsType], _reducer.initialNetworkState);
};
const tlsSelector = () => (0, _reselect.createSelector)(selectTlsByType, tlsQueries => tlsQueries);
exports.tlsSelector = tlsSelector;
const selectTopCountriesByType = (state, networkType, flowTarget) => {
  const ft = flowTarget === _network.FlowTargetSourceDest.source ? 'topCountriesSource' : 'topCountriesDestination';
  const nFlowType = networkType === _model.NetworkType.page ? _model.NetworkTableType[ft] : _model.NetworkDetailsTableType[ft];
  return (0, _fp.get)([networkType, 'queries', nFlowType], state.network) || (0, _fp.get)([networkType, 'queries', nFlowType], _reducer.initialNetworkState);
};
const topCountriesSelector = () => (0, _reselect.createSelector)(selectTopCountriesByType, topCountriesQueries => topCountriesQueries);
exports.topCountriesSelector = topCountriesSelector;
const selectHttpByType = (state, networkType) => {
  const httpType = networkType === _model.NetworkType.page ? _model.NetworkTableType.http : _model.NetworkDetailsTableType.http;
  return (0, _fp.get)([networkType, 'queries', httpType], state.network) || (0, _fp.get)([networkType, 'queries', httpType], _reducer.initialNetworkState);
};
const httpSelector = () => (0, _reselect.createSelector)(selectHttpByType, httpQueries => httpQueries);
exports.httpSelector = httpSelector;
const usersSelector = () => (0, _reselect.createSelector)(selectNetworkDetails, network => network.queries.users);
exports.usersSelector = usersSelector;
const networkAnomaliesJobIdFilterSelector = () => (0, _reselect.createSelector)(selectNetwork, network => network.queries[_model.NetworkTableType.anomalies].jobIdSelection);
exports.networkAnomaliesJobIdFilterSelector = networkAnomaliesJobIdFilterSelector;
const networkAnomaliesIntervalSelector = () => (0, _reselect.createSelector)(selectNetwork, network => network.queries[_model.NetworkTableType.anomalies].intervalSelection);
exports.networkAnomaliesIntervalSelector = networkAnomaliesIntervalSelector;