"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.NetworkType = exports.NetworkTableType = exports.NetworkDetailsTableType = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
let NetworkType = exports.NetworkType = /*#__PURE__*/function (NetworkType) {
  NetworkType["page"] = "page";
  NetworkType["details"] = "details";
  return NetworkType;
}({});
let NetworkTableType = exports.NetworkTableType = /*#__PURE__*/function (NetworkTableType) {
  NetworkTableType["alerts"] = "alerts";
  NetworkTableType["dns"] = "dns";
  NetworkTableType["http"] = "http";
  NetworkTableType["topCountriesDestination"] = "topCountriesDestination";
  NetworkTableType["topCountriesSource"] = "topCountriesSource";
  NetworkTableType["topNFlowDestination"] = "topNFlowDestination";
  NetworkTableType["topNFlowSource"] = "topNFlowSource";
  NetworkTableType["tls"] = "tls";
  NetworkTableType["anomalies"] = "anomalies";
  return NetworkTableType;
}({});
let NetworkDetailsTableType = exports.NetworkDetailsTableType = /*#__PURE__*/function (NetworkDetailsTableType) {
  NetworkDetailsTableType["http"] = "http";
  NetworkDetailsTableType["tls"] = "tls";
  NetworkDetailsTableType["topCountriesDestination"] = "topCountriesDestination";
  NetworkDetailsTableType["topCountriesSource"] = "topCountriesSource";
  NetworkDetailsTableType["topNFlowDestination"] = "topNFlowDestination";
  NetworkDetailsTableType["topNFlowSource"] = "topNFlowSource";
  NetworkDetailsTableType["users"] = "users";
  NetworkDetailsTableType["anomalies"] = "anomalies";
  return NetworkDetailsTableType;
}({}); // Network Page Models