"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.rowItems = exports.histogramConfigs = exports.getUsersPageAuthenticationColumns = exports.getUserDetailsAuthenticationColumns = exports.getHostsPageAuthenticationColumns = exports.getHostDetailsAuthenticationColumns = exports.authenticationsStackByOptions = void 0;
var _fp = require("lodash/fp");
var _react = _interopRequireDefault(require("react"));
var _empty_value = require("../../../common/components/empty_value");
var _formatted_date = require("../../../common/components/formatted_date");
var _helpers = require("../../../common/components/tables/helpers");
var i18n = _interopRequireWildcard(require("./translations"));
var _links = require("../../../common/components/links");
var _authentication = require("../../../common/components/visualization_actions/lens_attributes/common/authentication");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761322521701505730/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/explore/components/authentication/helpers.tsx",
  _authenticationsStack;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const getHostDetailsAuthenticationColumns = () => [USER_COLUMN, SUCCESS_COLUMN, FAILURES_COLUMN, LAST_SUCCESSFUL_TIME_COLUMN, LAST_SUCCESSFUL_SOURCE_COLUMN, LAST_FAILED_TIME_COLUMN, LAST_FAILED_SOURCE_COLUMN];
exports.getHostDetailsAuthenticationColumns = getHostDetailsAuthenticationColumns;
const getHostsPageAuthenticationColumns = () => [USER_COLUMN, SUCCESS_COLUMN, FAILURES_COLUMN, LAST_SUCCESSFUL_TIME_COLUMN, LAST_SUCCESSFUL_SOURCE_COLUMN, LAST_SUCCESSFUL_DESTINATION_COLUMN, LAST_FAILED_TIME_COLUMN, LAST_FAILED_SOURCE_COLUMN, LAST_FAILED_DESTINATION_COLUMN];
exports.getHostsPageAuthenticationColumns = getHostsPageAuthenticationColumns;
const getUsersPageAuthenticationColumns = () => getHostsPageAuthenticationColumns();
exports.getUsersPageAuthenticationColumns = getUsersPageAuthenticationColumns;
const getUserDetailsAuthenticationColumns = () => [HOST_COLUMN, SUCCESS_COLUMN, FAILURES_COLUMN, LAST_SUCCESSFUL_TIME_COLUMN, LAST_SUCCESSFUL_SOURCE_COLUMN, LAST_FAILED_TIME_COLUMN, LAST_FAILED_SOURCE_COLUMN];
exports.getUserDetailsAuthenticationColumns = getUserDetailsAuthenticationColumns;
const rowItems = exports.rowItems = [{
  text: i18n.ROWS_5,
  numberOfRow: 5
}, {
  text: i18n.ROWS_10,
  numberOfRow: 10
}];
const FAILURES_COLUMN = {
  name: i18n.FAILURES,
  field: 'node.failures',
  truncateText: false,
  mobileOptions: {
    show: true
  },
  width: '8%'
};
const LAST_SUCCESSFUL_TIME_COLUMN = {
  name: i18n.LAST_SUCCESSFUL_TIME,
  truncateText: false,
  mobileOptions: {
    show: true
  },
  render: ({
    node
  }) => {
    var _node$lastSuccess, _node$lastSuccess2;
    return (0, _fp.has)('lastSuccess.timestamp', node) && ((_node$lastSuccess = node.lastSuccess) === null || _node$lastSuccess === void 0 ? void 0 : _node$lastSuccess.timestamp) != null ? /*#__PURE__*/_react.default.createElement(_formatted_date.FormattedRelativePreferenceDate, {
      value: (_node$lastSuccess2 = node.lastSuccess) === null || _node$lastSuccess2 === void 0 ? void 0 : _node$lastSuccess2.timestamp,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 88,
        columnNumber: 7
      }
    }) : (0, _empty_value.getEmptyTagValue)();
  }
};
const LAST_SUCCESSFUL_SOURCE_COLUMN = {
  name: i18n.LAST_SUCCESSFUL_SOURCE,
  truncateText: false,
  mobileOptions: {
    show: true
  },
  render: ({
    node
  }) => {
    var _node$lastSuccess3, _node$lastSuccess3$so;
    return (0, _helpers.getRowItemsWithActions)({
      values: ((_node$lastSuccess3 = node.lastSuccess) === null || _node$lastSuccess3 === void 0 ? void 0 : (_node$lastSuccess3$so = _node$lastSuccess3.source) === null || _node$lastSuccess3$so === void 0 ? void 0 : _node$lastSuccess3$so.ip) || null,
      fieldName: 'source.ip',
      idPrefix: `authentications-table-${node._id}-lastSuccessSource`,
      render: item => /*#__PURE__*/_react.default.createElement(_links.NetworkDetailsLink, {
        ip: item,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 102,
          columnNumber: 25
        }
      })
    });
  }
};
const LAST_SUCCESSFUL_DESTINATION_COLUMN = {
  name: i18n.LAST_SUCCESSFUL_DESTINATION,
  truncateText: false,
  mobileOptions: {
    show: true
  },
  render: ({
    node
  }) => {
    var _node$lastSuccess$hos, _node$lastSuccess4, _node$lastSuccess4$ho;
    return (0, _helpers.getRowItemsWithActions)({
      values: (_node$lastSuccess$hos = (_node$lastSuccess4 = node.lastSuccess) === null || _node$lastSuccess4 === void 0 ? void 0 : (_node$lastSuccess4$ho = _node$lastSuccess4.host) === null || _node$lastSuccess4$ho === void 0 ? void 0 : _node$lastSuccess4$ho.name) !== null && _node$lastSuccess$hos !== void 0 ? _node$lastSuccess$hos : null,
      fieldName: 'host.name',
      idPrefix: `authentications-table-${node._id}-lastSuccessfulDestination`,
      render: item => /*#__PURE__*/_react.default.createElement(_links.HostDetailsLink, {
        hostName: item,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 114,
          columnNumber: 25
        }
      })
    });
  }
};
const LAST_FAILED_TIME_COLUMN = {
  name: i18n.LAST_FAILED_TIME,
  truncateText: false,
  mobileOptions: {
    show: true
  },
  render: ({
    node
  }) => {
    var _node$lastFailure, _node$lastFailure2;
    return (0, _fp.has)('lastFailure.timestamp', node) && ((_node$lastFailure = node.lastFailure) === null || _node$lastFailure === void 0 ? void 0 : _node$lastFailure.timestamp) != null ? /*#__PURE__*/_react.default.createElement(_formatted_date.FormattedRelativePreferenceDate, {
      value: (_node$lastFailure2 = node.lastFailure) === null || _node$lastFailure2 === void 0 ? void 0 : _node$lastFailure2.timestamp,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 123,
        columnNumber: 7
      }
    }) : (0, _empty_value.getEmptyTagValue)();
  }
};
const LAST_FAILED_SOURCE_COLUMN = {
  name: i18n.LAST_FAILED_SOURCE,
  truncateText: false,
  mobileOptions: {
    show: true
  },
  render: ({
    node
  }) => {
    var _node$lastFailure3, _node$lastFailure3$so;
    return (0, _helpers.getRowItemsWithActions)({
      values: ((_node$lastFailure3 = node.lastFailure) === null || _node$lastFailure3 === void 0 ? void 0 : (_node$lastFailure3$so = _node$lastFailure3.source) === null || _node$lastFailure3$so === void 0 ? void 0 : _node$lastFailure3$so.ip) || null,
      fieldName: 'source.ip',
      idPrefix: `authentications-table-${node._id}-lastFailureSource`,
      render: item => /*#__PURE__*/_react.default.createElement(_links.NetworkDetailsLink, {
        ip: item,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 137,
          columnNumber: 25
        }
      })
    });
  }
};
const LAST_FAILED_DESTINATION_COLUMN = {
  name: i18n.LAST_FAILED_DESTINATION,
  truncateText: false,
  mobileOptions: {
    show: true
  },
  render: ({
    node
  }) => {
    var _node$lastFailure4, _node$lastFailure4$ho;
    return (0, _helpers.getRowItemsWithActions)({
      values: ((_node$lastFailure4 = node.lastFailure) === null || _node$lastFailure4 === void 0 ? void 0 : (_node$lastFailure4$ho = _node$lastFailure4.host) === null || _node$lastFailure4$ho === void 0 ? void 0 : _node$lastFailure4$ho.name) || null,
      fieldName: 'host.name',
      idPrefix: `authentications-table-${node._id}-lastFailureDestination`,
      render: item => /*#__PURE__*/_react.default.createElement(_links.HostDetailsLink, {
        hostName: item,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 149,
          columnNumber: 25
        }
      })
    });
  }
};
const USER_COLUMN = {
  name: i18n.USER,
  truncateText: false,
  mobileOptions: {
    show: true
  },
  render: ({
    node
  }) => (0, _helpers.getRowItemsWithActions)({
    values: node.stackedValue,
    fieldName: 'user.name',
    idPrefix: `authentications-table-${node._id}-userName`,
    render: item => /*#__PURE__*/_react.default.createElement(_links.UserDetailsLink, {
      userName: item,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 162,
        columnNumber: 25
      }
    })
  })
};
const HOST_COLUMN = {
  name: i18n.HOST,
  truncateText: false,
  mobileOptions: {
    show: true
  },
  render: ({
    node
  }) => (0, _helpers.getRowItemsWithActions)({
    values: node.stackedValue,
    fieldName: 'host.name',
    idPrefix: `authentications-table-${node._id}-hostName`,
    render: item => /*#__PURE__*/_react.default.createElement(_links.HostDetailsLink, {
      hostName: item,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 175,
        columnNumber: 25
      }
    })
  })
};
const SUCCESS_COLUMN = {
  name: i18n.SUCCESSES,
  field: 'node.successes',
  truncateText: false,
  mobileOptions: {
    show: true
  },
  width: '8%'
};
const authenticationsStackByOptions = exports.authenticationsStackByOptions = [{
  text: 'event.outcome',
  value: 'event.outcome'
}];
const DEFAULT_STACK_BY = 'event.outcome';
const histogramConfigs = exports.histogramConfigs = {
  defaultStackByOption: (_authenticationsStack = authenticationsStackByOptions.find(o => o.text === DEFAULT_STACK_BY)) !== null && _authenticationsStack !== void 0 ? _authenticationsStack : authenticationsStackByOptions[0],
  stackByOptions: authenticationsStackByOptions,
  title: i18n.NAVIGATION_AUTHENTICATIONS_TITLE,
  getLensAttributes: _authentication.getAuthenticationLensAttributes
};