"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useEntityStoreTypes = exports.useEntityAnalyticsTypes = void 0;
var _react = require("react");
var _public = require("@kbn/kibana-react-plugin/public");
var _managementSettingsIds = require("@kbn/management-settings-ids");
var _utils = require("../../../common/entity_analytics/utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useEntityStoreTypes = () => {
  const [genericEntityStoreEnabled] = (0, _public.useUiSetting$)(_managementSettingsIds.SECURITY_SOLUTION_ENABLE_ASSET_INVENTORY_SETTING);
  return (0, _react.useMemo)(() => (0, _utils.getEnabledEntityTypes)(genericEntityStoreEnabled), [genericEntityStoreEnabled]);
};
exports.useEntityStoreTypes = useEntityStoreTypes;
const useEntityAnalyticsTypes = () => {
  return (0, _react.useMemo)(() => (0, _utils.getEntityAnalyticsEntityTypes)(), []);
};
exports.useEntityAnalyticsTypes = useEntityAnalyticsTypes;