"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useEntityEnginePrivileges = exports.GET_ENTITY_ENGINE_PRIVILEGES = void 0;
var _reactQuery = require("@tanstack/react-query");
var _api = require("../../../api/api");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const GET_ENTITY_ENGINE_PRIVILEGES = exports.GET_ENTITY_ENGINE_PRIVILEGES = ['get_entity_engine_privileges'];
const useEntityEnginePrivileges = () => {
  const {
    fetchEntityStorePrivileges
  } = (0, _api.useEntityAnalyticsRoutes)();
  return (0, _reactQuery.useQuery)(GET_ENTITY_ENGINE_PRIVILEGES, fetchEntityStorePrivileges);
};
exports.useEntityEnginePrivileges = useEntityEnginePrivileges;