"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useRiskScore = exports.initialResult = void 0;
var _react = require("react");
var _i18n = require("@kbn/i18n");
var _search_strategy = require("../../../../common/api/search_strategy");
var _use_ml_capabilities = require("../../../common/components/ml/hooks/use_ml_capabilities");
var _helpers = require("../../../common/containers/helpers");
var _use_app_toasts = require("../../../common/hooks/use_app_toasts");
var _exceptions = require("../../../common/utils/exceptions");
var _use_search_strategy = require("../../../common/containers/use_search_strategy");
var _use_get_default_risk_index = require("../../hooks/use_get_default_risk_index");
var _helper_hooks = require("../../../helper_hooks");
var _use_risk_engine_status = require("./use_risk_engine_status");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const initialResult = exports.initialResult = {
  totalCount: 0,
  data: undefined
};
const useRiskScore = ({
  timerange,
  onlyLatest = true,
  filterQuery,
  sort,
  skip = false,
  pagination,
  riskEntity,
  includeAlertsCount = false
}) => {
  const defaultIndex = (0, _use_get_default_risk_index.useGetDefaultRiskIndex)(onlyLatest);
  const {
    data: riskEngineStatus,
    isFetching: isStatusLoading,
    refetch: refetchEngineStatus
  } = (0, _use_risk_engine_status.useRiskEngineStatus)();
  const factoryQueryType = _search_strategy.EntityRiskQueries.list;
  const {
    querySize,
    cursorStart
  } = pagination || {};
  const {
    addError
  } = (0, _use_app_toasts.useAppToasts)();
  const {
    isPlatinumOrTrialLicense
  } = (0, _use_ml_capabilities.useMlCapabilities)();
  const hasEntityAnalyticsCapability = (0, _helper_hooks.useHasSecurityCapability)('entity-analytics');
  const isAuthorized = isPlatinumOrTrialLicense && hasEntityAnalyticsCapability;
  const hasEngineBeenInstalled = (riskEngineStatus === null || riskEngineStatus === void 0 ? void 0 : riskEngineStatus.risk_engine_status) !== 'NOT_INSTALLED';
  const {
    loading,
    result: response,
    search,
    refetch,
    inspect,
    error
  } = (0, _use_search_strategy.useSearchStrategy)({
    factoryQueryType,
    initialResult,
    abort: skip,
    showErrorToast: false
  });
  const refetchAll = (0, _react.useCallback)(() => {
    if (defaultIndex) {
      refetchEngineStatus();
      refetch();
    }
  }, [defaultIndex, refetch, refetchEngineStatus]);
  const riskScoreResponse = (0, _react.useMemo)(() => ({
    data: response.data,
    inspect,
    refetch: refetchAll,
    totalCount: response.totalCount,
    isAuthorized,
    isInspected: false,
    hasEngineBeenInstalled,
    error
  }), [response.data, response.totalCount, inspect, refetchAll, isAuthorized, hasEngineBeenInstalled, error]);
  const requestTimerange = (0, _react.useMemo)(() => timerange ? {
    to: timerange.to,
    from: timerange.from,
    interval: ''
  } : undefined, [timerange]);
  const riskScoreRequest = (0, _react.useMemo)(() => defaultIndex ? {
    defaultIndex: [defaultIndex],
    factoryQueryType,
    riskScoreEntity: riskEntity,
    includeAlertsCount,
    filterQuery: (0, _helpers.createFilter)(filterQuery),
    pagination: cursorStart !== undefined && querySize !== undefined ? {
      cursorStart,
      querySize
    } : undefined,
    sort,
    timerange: requestTimerange,
    alertsTimerange: includeAlertsCount ? requestTimerange : undefined
  } : null, [cursorStart, defaultIndex, factoryQueryType, filterQuery, querySize, sort, requestTimerange, riskEntity, includeAlertsCount]);
  (0, _react.useEffect)(() => {
    if (error) {
      if (!(0, _exceptions.isIndexNotFoundError)(error) && !(0, _exceptions.isAbortError)(error)) {
        addError(error, {
          title: _i18n.i18n.translate('xpack.securitySolution.riskScore.failSearchDescription', {
            defaultMessage: `Failed to run search on risk score`
          })
        });
      }
    }
  }, [addError, error]);
  (0, _react.useEffect)(() => {
    if (!skip && riskScoreRequest != null && isAuthorized && hasEngineBeenInstalled) {
      search(riskScoreRequest);
    }
  }, [hasEngineBeenInstalled, isAuthorized, riskScoreRequest, search, skip]);
  const result = {
    ...riskScoreResponse,
    loading: loading || isStatusLoading
  };
  return result;
};
exports.useRiskScore = useRiskScore;