"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useRefetchOverviewPageRiskScore = void 0;
var _securitysolutionDataTable = require("@kbn/securitysolution-data-table");
var _react = require("react");
var _use_refetch_query_by_id = require("./use_refetch_query_by_id");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useRefetchOverviewPageRiskScore = overviewRiskScoreQueryId => {
  const refetchOverviewRiskScore = (0, _use_refetch_query_by_id.useRefetchQueryById)(overviewRiskScoreQueryId);
  const refetchAlertsRiskInputs = (0, _use_refetch_query_by_id.useRefetchQueryById)(_securitysolutionDataTable.TableId.alertsRiskInputs);
  const refetchRiskScore = (0, _react.useCallback)(() => {
    if (refetchOverviewRiskScore) {
      refetchOverviewRiskScore();
    }
    if (refetchAlertsRiskInputs) {
      refetchAlertsRiskInputs();
    }
  }, [refetchAlertsRiskInputs, refetchOverviewRiskScore]);
  return refetchRiskScore;
};
exports.useRefetchOverviewPageRiskScore = useRefetchOverviewPageRiskScore;