"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getAlertFieldValueAsStringOrNull = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Takes an Alert object and a field string as input and returns the value for the field as a string.
 * If the value is already a string, return it.
 * If the value is an array, join the values.
 * If null the value is null.
 * Return the string of the value otherwise.
 */
const getAlertFieldValueAsStringOrNull = (alert, field) => {
  const cellValues = alert[field];
  if (typeof cellValues === 'string') {
    return cellValues;
  } else if (typeof cellValues === 'number') {
    return cellValues.toString();
  } else if (Array.isArray(cellValues)) {
    if (cellValues.length > 1) {
      return cellValues.join(', ');
    } else {
      const value = cellValues[0];
      if (typeof value === 'string') {
        return value;
      } else if (value == null) {
        return null;
      } else {
        return value.toString();
      }
    }
  } else {
    return null;
  }
};
exports.getAlertFieldValueAsStringOrNull = getAlertFieldValueAsStringOrNull;