"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useOsqueryContextActionItem = void 0;
var _react = require("react");
var _osquery_action_item = require("./osquery_action_item");
var _kibana = require("../../../common/lib/kibana");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useOsqueryContextActionItem = ({
  handleClick
}) => {
  const osqueryActionItem = (0, _react.useMemo)(() => (0, _osquery_action_item.getOsqueryActionItem)({
    handleClick
  }), [handleClick]);
  const permissions = (0, _kibana.useKibana)().services.application.capabilities.osquery;
  return {
    osqueryActionItems: permissions !== null && permissions !== void 0 && permissions.writeLiveQueries || permissions !== null && permissions !== void 0 && permissions.runSavedQueries ? [osqueryActionItem] : []
  };
};
exports.useOsqueryContextActionItem = useOsqueryContextActionItem;