"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.defaultGroupingOptions = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const RULE_NAME = _i18n.i18n.translate('xpack.securitySolution.alertsTable.groups.ruleName', {
  defaultMessage: 'Rule name'
});
const USER_NAME = _i18n.i18n.translate('xpack.securitySolution.alertsTable.groups.userName', {
  defaultMessage: 'User name'
});
const HOST_NAME = _i18n.i18n.translate('xpack.securitySolution.alertsTable.groups.hostName', {
  defaultMessage: 'Host name'
});
const SOURCE_IP = _i18n.i18n.translate('xpack.securitySolution.alertsTable.groups.sourceIP', {
  defaultMessage: 'Source IP'
});

/**
 * Returns a list of fields for the default grouping options. These are displayed in the `Group alerts by` dropdown button.
 *
 * These go hand in hand with defaultGroupTitleRenderers, defaultGroupStats and defaultGroupStatsAggregations.
 */
const defaultGroupingOptions = exports.defaultGroupingOptions = [{
  label: RULE_NAME,
  key: 'kibana.alert.rule.name'
}, {
  label: USER_NAME,
  key: 'user.name'
}, {
  label: HOST_NAME,
  key: 'host.name'
}, {
  label: SOURCE_IP,
  key: 'source.ip'
}];