"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AlertsTableFilterGroup = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _types = require("../../../../../common/types");
var i18n = _interopRequireWildcard(require("../translations"));
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761322521701505730/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/detections/components/alerts_table/alerts_filter_group/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const AlertsTableFilterGroupComponent = ({
  status = _types.FILTER_OPEN,
  onFilterGroupChanged
}) => {
  const options = [{
    id: 'open',
    label: i18n.OPEN_ALERTS,
    'data-test-subj': 'openAlerts'
  }, {
    id: 'acknowledged',
    label: i18n.ACKNOWLEDGED_ALERTS,
    'data-test-subj': 'acknowledgedAlerts'
  }, {
    id: 'closed',
    label: i18n.CLOSED_ALERTS,
    'data-test-subj': 'closedAlerts'
  }];
  const onChange = (0, _react.useCallback)(id => {
    onFilterGroupChanged(id);
  }, [onFilterGroupChanged]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiButtonGroup, {
    legend: "filter status",
    color: "primary",
    options: options,
    idSelected: status,
    "data-test-subj": "alerts-table-filter-group",
    onChange: onChange,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 50,
      columnNumber: 5
    }
  });
};
const AlertsTableFilterGroup = exports.AlertsTableFilterGroup = /*#__PURE__*/_react.default.memo(AlertsTableFilterGroupComponent);