"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.parseSeverityData = exports.getSeverityColor = exports.getIsAlertsBySeverityData = exports.getIsAlertsBySeverityAgg = void 0;
var _lodash = require("lodash");
var _use_alerts_by_status = require("../../../../overview/components/detection_response/alerts_by_status/use_alerts_by_status");
var _risk_color_palette = require("../../../../common/utils/risk_color_palette");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SEVERITY_ORDER = ['critical', 'high', 'medium', 'low'];
const getSeverityColor = (severity, euiTheme) => {
  var _palette;
  const palette = (0, _risk_color_palette.getRiskSeverityColors)(euiTheme);
  return (_palette = palette[severity.toLocaleLowerCase()]) !== null && _palette !== void 0 ? _palette : euiTheme.colors.textSubdued;
};
exports.getSeverityColor = getSeverityColor;
const parseSeverityData = response => {
  var _response$aggregation, _response$aggregation2, _response$aggregation3;
  const severityBuckets = (_response$aggregation = response === null || response === void 0 ? void 0 : (_response$aggregation2 = response.aggregations) === null || _response$aggregation2 === void 0 ? void 0 : (_response$aggregation3 = _response$aggregation2.statusBySeverity) === null || _response$aggregation3 === void 0 ? void 0 : _response$aggregation3.buckets) !== null && _response$aggregation !== void 0 ? _response$aggregation : [];
  return severityBuckets.length === 0 ? [] : severityBuckets.map(severity => {
    return {
      key: severity.key,
      value: severity.doc_count,
      label: _use_alerts_by_status.severityLabels[severity.key]
    };
  }).sort((a, b) => {
    const aIndex = SEVERITY_ORDER.indexOf(a.key);
    const bIndex = SEVERITY_ORDER.indexOf(b.key);
    return aIndex - bIndex;
  });
};
exports.parseSeverityData = parseSeverityData;
const getIsAlertsBySeverityData = data => {
  return data === null || data === void 0 ? void 0 : data.every(x => (0, _lodash.has)(x, 'key'));
};
exports.getIsAlertsBySeverityData = getIsAlertsBySeverityData;
const getIsAlertsBySeverityAgg = data => {
  return (0, _lodash.has)(data, 'aggregations.statusBySeverity');
};
exports.getIsAlertsBySeverityAgg = getIsAlertsBySeverityAgg;