"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.parseChartCollapseData = exports.getIsChartCollapseData = exports.getIsChartCollapseAgg = void 0;
var _lodash = require("lodash");
var _use_alerts_by_status = require("../../../../../overview/components/detection_response/alerts_by_status/use_alerts_by_status");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const parseChartCollapseData = response => {
  var _response$aggregation, _response$aggregation2, _response$aggregation3, _response$aggregation4, _response$aggregation5, _response$aggregation6, _response$aggregation7, _response$aggregation8, _response$aggregation9, _response$aggregation10, _response$aggregation11, _response$aggregation12, _response$aggregation13;
  const ret = {
    rule: null,
    group: null,
    severities: []
  };
  ret.rule = (_response$aggregation = response === null || response === void 0 ? void 0 : (_response$aggregation2 = response.aggregations) === null || _response$aggregation2 === void 0 ? void 0 : (_response$aggregation3 = _response$aggregation2.topRule) === null || _response$aggregation3 === void 0 ? void 0 : (_response$aggregation4 = _response$aggregation3.buckets) === null || _response$aggregation4 === void 0 ? void 0 : (_response$aggregation5 = _response$aggregation4.at(0)) === null || _response$aggregation5 === void 0 ? void 0 : _response$aggregation5.key) !== null && _response$aggregation !== void 0 ? _response$aggregation : null;
  ret.group = (_response$aggregation6 = response === null || response === void 0 ? void 0 : (_response$aggregation7 = response.aggregations) === null || _response$aggregation7 === void 0 ? void 0 : (_response$aggregation8 = _response$aggregation7.topGrouping) === null || _response$aggregation8 === void 0 ? void 0 : (_response$aggregation9 = _response$aggregation8.buckets) === null || _response$aggregation9 === void 0 ? void 0 : (_response$aggregation10 = _response$aggregation9.at(0)) === null || _response$aggregation10 === void 0 ? void 0 : _response$aggregation10.key) !== null && _response$aggregation6 !== void 0 ? _response$aggregation6 : null;
  const severityBuckets = (_response$aggregation11 = response === null || response === void 0 ? void 0 : (_response$aggregation12 = response.aggregations) === null || _response$aggregation12 === void 0 ? void 0 : (_response$aggregation13 = _response$aggregation12.severities) === null || _response$aggregation13 === void 0 ? void 0 : _response$aggregation13.buckets) !== null && _response$aggregation11 !== void 0 ? _response$aggregation11 : [];
  if (severityBuckets.length > 0) {
    ret.severities = severityBuckets.map(severity => {
      return {
        key: severity.key,
        value: severity.doc_count,
        label: _use_alerts_by_status.severityLabels[severity.key]
      };
    });
    return [ret];
  }
  return [];
};
exports.parseChartCollapseData = parseChartCollapseData;
const getIsChartCollapseData = data => {
  return data === null || data === void 0 ? void 0 : data.every(x => (0, _lodash.has)(x, 'rule') && (0, _lodash.has)(x, 'group') && (0, _lodash.has)(x, 'severities'));
};
exports.getIsChartCollapseData = getIsChartCollapseData;
const getIsChartCollapseAgg = data => {
  return (0, _lodash.has)(data, 'aggregations.severities') && (0, _lodash.has)(data, 'aggregations.topRule') && (0, _lodash.has)(data, 'aggregations.topGrouping');
};
exports.getIsChartCollapseAgg = getIsChartCollapseAgg;