"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useSummaryChartData = exports.getAlertsQuery = void 0;
var _react = require("react");
var _esQuery = require("@kbn/es-query");
var _common = require("@kbn/data-plugin/common");
var _kibana = require("../../../../common/lib/kibana");
var _use_global_time = require("../../../../common/containers/use_global_time");
var _use_query = require("../../../containers/detection_engine/alerts/use_query");
var _constants = require("../../../containers/detection_engine/alerts/constants");
var _hooks = require("../common/hooks");
var _helpers = require("./helpers");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getAlertsQuery = ({
  additionalFilters = [],
  from,
  to,
  entityFilter,
  runtimeMappings,
  aggregations
}) => ({
  size: 0,
  query: {
    bool: {
      filter: [...additionalFilters, {
        range: {
          '@timestamp': {
            gte: from,
            lte: to
          }
        }
      }, ...(entityFilter ? [{
        term: {
          [entityFilter.field]: entityFilter.value
        }
      }] : [])]
    }
  },
  aggs: aggregations,
  runtime_mappings: runtimeMappings
});
exports.getAlertsQuery = getAlertsQuery;
const useSummaryChartData = ({
  aggregations,
  uniqueQueryId,
  entityFilter,
  query,
  filters,
  runtimeMappings,
  signalIndexName,
  skip = false
}) => {
  const {
    to,
    from,
    deleteQuery,
    setQuery
  } = (0, _use_global_time.useGlobalTime)();
  const [updatedAt, setUpdatedAt] = (0, _react.useState)(Date.now());
  const [items, setItems] = (0, _react.useState)([]);
  const {
    uiSettings
  } = (0, _kibana.useKibana)().services;
  const additionalFilters = (0, _react.useMemo)(() => {
    try {
      var _filters$filter;
      const config = (0, _common.getEsQueryConfig)(uiSettings);
      return [(0, _esQuery.buildEsQuery)(undefined, query != null ? [query] : [], (_filters$filter = filters === null || filters === void 0 ? void 0 : filters.filter(f => f.meta.disabled === false)) !== null && _filters$filter !== void 0 ? _filters$filter : [], config)];
    } catch (e) {
      return [];
    }
  }, [query, filters, uiSettings]);
  const {
    data,
    loading: isLoading,
    refetch: refetchQuery,
    request,
    response,
    setQuery: setAlertsQuery
  } = (0, _use_query.useQueryAlerts)({
    query: getAlertsQuery({
      from,
      to,
      entityFilter,
      additionalFilters,
      runtimeMappings,
      aggregations
    }),
    indexName: signalIndexName,
    skip,
    queryName: _constants.ALERTS_QUERY_NAMES.COUNT
  });
  (0, _react.useEffect)(() => {
    setAlertsQuery(getAlertsQuery({
      from,
      to,
      entityFilter,
      additionalFilters,
      runtimeMappings,
      aggregations
    }));
  }, [setAlertsQuery, from, to, entityFilter, additionalFilters, runtimeMappings, aggregations]);
  (0, _react.useEffect)(() => {
    if (data == null) {
      setItems([]);
    } else {
      setItems((0, _helpers.parseData)(data));
    }
    setUpdatedAt(Date.now());
  }, [data]);
  const refetch = (0, _react.useCallback)(() => {
    if (!skip && refetchQuery) {
      refetchQuery();
    }
  }, [skip, refetchQuery]);
  (0, _hooks.useInspectButton)({
    deleteQuery,
    loading: isLoading,
    response,
    setQuery,
    refetch,
    request,
    uniqueQueryId
  });
  return {
    items,
    isLoading,
    updatedAt
  };
};
exports.useSummaryChartData = useSummaryChartData;