"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AlertsProgressBar = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _securitysolutionDataTable = require("@kbn/securitysolution-data-table");
var _alerts_progress_bar_row = require("./alerts_progress_bar_row");
var _helpers = require("./helpers");
var i18n = _interopRequireWildcard(require("./translations"));
var _cell_actions = require("../../../../common/components/cell_actions");
var _helpers2 = require("../../../../helpers");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761322521701505730/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/detections/components/alerts_kpis/alerts_progress_bar_panel/alerts_progress_bar.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const ProgressWrapper = _styledComponents.default.div`
  height: 160px;
`;
const StyledEuiHorizontalRule = (0, _styledComponents.default)(_eui.EuiHorizontalRule)`
  margin-top: 0;
  margin-bottom: ${({
  theme
}) => theme.eui.euiSizeS};
`;
const StyledEuiFlexGroup = (0, _styledComponents.default)(_eui.EuiFlexGroup)`
  margin-top: -${({
  theme
}) => theme.eui.euiSizeM};
`;
const StyledEuiProgress = (0, _styledComponents.default)(_eui.EuiProgress)`
  margin-bottom: ${({
  theme
}) => theme.eui.euiSizeS};
`;
const DataStatsWrapper = _styledComponents.default.div`
  width: 250px;
`;
const EmptyAction = _styledComponents.default.div`
  padding-left: ${({
  theme
}) => theme.eui.euiSizeL};
`;
const AlertsProgressBar = ({
  data,
  isLoading,
  addFilter,
  groupBySelection
}) => {
  const [isPopoverOpen, setIsPopoverOpen] = (0, _react.useState)(false);
  const onButtonClick = () => setIsPopoverOpen(!isPopoverOpen);
  const closePopover = () => setIsPopoverOpen(false);
  const [nonEmpty, formattedNonEmptyPercent] = (0, _react.useMemo)(() => (0, _helpers.getAggregateData)(data), [data]);
  const sourcererScopeId = (0, _react.useMemo)(() => (0, _helpers2.getSourcererScopeId)(_securitysolutionDataTable.TableId.alertsOnAlertsPage), []);
  const dataStatsButton = /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    color: "text",
    iconType: "info",
    "aria-label": "info",
    size: "xs",
    onClick: onButtonClick,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 93,
      columnNumber: 5
    }
  });
  const dataStatsMessage = /*#__PURE__*/_react.default.createElement(DataStatsWrapper, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 103,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPopoverTitle, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 104,
      columnNumber: 7
    }
  }, i18n.DATA_STATISTICS_TITLE(formattedNonEmptyPercent)), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 105,
      columnNumber: 7
    }
  }, i18n.DATA_STATISTICS_MESSAGE(groupBySelection), /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    color: "primary",
    onClick: () => {
      setIsPopoverOpen(false);
      if (addFilter) {
        addFilter({
          field: groupBySelection,
          value: null,
          negate: true
        });
      }
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 107,
      columnNumber: 9
    }
  }, i18n.NON_EMPTY_FILTER(groupBySelection))));
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(StyledEuiFlexGroup, {
    alignItems: "center",
    gutterSize: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 124,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 125,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    "data-test-subj": "alerts-progress-bar-title",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 126,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement("h5", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 127,
      columnNumber: 13
    }
  }, groupBySelection))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 130,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    button: dataStatsButton,
    isOpen: isPopoverOpen,
    closePopover: closePopover,
    anchorPosition: "rightCenter",
    panelPaddingSize: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 131,
      columnNumber: 11
    }
  }, dataStatsMessage))), isLoading ? /*#__PURE__*/_react.default.createElement(StyledEuiProgress, {
    size: "xs",
    color: "primary",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 143,
      columnNumber: 9
    }
  }) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(StyledEuiHorizontalRule, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 146,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(ProgressWrapper, {
    "data-test-subj": "progress-bar",
    className: "eui-yScroll",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 147,
      columnNumber: 11
    }
  }, nonEmpty === 0 ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    textAlign: "center",
    "data-test-subj": "empty-proress-bar",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 150,
      columnNumber: 17
    }
  }, i18n.EMPTY_DATA_MESSAGE), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 153,
      columnNumber: 17
    }
  })) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, data.filter(item => item.key !== '-').map(item => /*#__PURE__*/_react.default.createElement("div", {
    key: `${item.key}`,
    "data-test-subj": `progress-bar-${item.key}`,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 160,
      columnNumber: 21
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    gutterSize: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 161,
      columnNumber: 23
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 162,
      columnNumber: 25
    }
  }, /*#__PURE__*/_react.default.createElement(_alerts_progress_bar_row.ProgressBarRow, {
    item: item,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 163,
      columnNumber: 27
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    "data-test-subj": `progress-bar-${item.key}-actions`,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 165,
      columnNumber: 25
    }
  }, item.key !== 'Other' ? /*#__PURE__*/_react.default.createElement(_cell_actions.SecurityCellActions, {
    mode: _cell_actions.CellActionsMode.INLINE,
    visibleCellActions: 0,
    triggerId: _cell_actions.SecurityCellActionsTrigger.DEFAULT,
    data: {
      field: groupBySelection,
      value: item.key
    },
    sourcererScopeId: sourcererScopeId,
    metadata: {
      scopeId: _securitysolutionDataTable.TableId.alertsOnAlertsPage
    },
    disabledActionTypes: [_cell_actions.SecurityCellActionType.SHOW_TOP_N],
    extraActionsIconType: "boxesVertical",
    extraActionsColor: "text",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 170,
      columnNumber: 29
    }
  }) : /*#__PURE__*/_react.default.createElement(EmptyAction, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 182,
      columnNumber: 29
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 186,
      columnNumber: 23
    }
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 191,
      columnNumber: 13
    }
  }))));
};
exports.AlertsProgressBar = AlertsProgressBar;
AlertsProgressBar.displayName = 'AlertsProgressBar';