"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getActionDetails = void 0;
var _rule_response_actions = require("../../../common/api/detection_engine/model/rule_response_actions");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getActionDetails = actionTypeId => {
  switch (actionTypeId) {
    case _rule_response_actions.ResponseActionTypesEnum['.osquery']:
      return {
        logo: 'logoOsquery',
        name: 'Osquery'
      };
    case _rule_response_actions.ResponseActionTypesEnum['.endpoint']:
      return {
        logo: 'logoSecurity',
        name: 'Elastic Defend'
      };
    // update when new responseActions are provided
    default:
      return {
        logo: 'logoOsquery',
        name: 'Osquery'
      };
  }
};
exports.getActionDetails = getActionDetails;