"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useAsyncConfirmation = void 0;
var _react = require("react");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// TODO move to common hooks
// eslint-disable-next-line @typescript-eslint/no-explicit-any
const useAsyncConfirmation = ({
  onInit,
  onFinish
}) => {
  const confirmationPromiseRef = (0, _react.useRef)();
  const confirm = (0, _react.useCallback)(result => {
    var _confirmationPromiseR;
    (_confirmationPromiseR = confirmationPromiseRef.current) === null || _confirmationPromiseR === void 0 ? void 0 : _confirmationPromiseR.call(confirmationPromiseRef, result !== null && result !== void 0 ? result : true);
  }, []);
  const cancel = (0, _react.useCallback)(() => {
    var _confirmationPromiseR2;
    (_confirmationPromiseR2 = confirmationPromiseRef.current) === null || _confirmationPromiseR2 === void 0 ? void 0 : _confirmationPromiseR2.call(confirmationPromiseRef, false);
  }, []);
  const initConfirmation = (0, _react.useCallback)(() => {
    onInit();
    return new Promise(resolve => {
      confirmationPromiseRef.current = resolve;
    }).finally(() => {
      onFinish();
    });
  }, [onInit, onFinish]);
  return [initConfirmation, confirm, cancel];
};
exports.useAsyncConfirmation = useAsyncConfirmation;