"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.usePrebuiltRuleCustomizationUpsellingMessage = void 0;
var _use_upselling = require("../../../../common/hooks/use_upselling");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * This hook returns an upselling message when the license level is insufficient
 * for prebuilt rule customization. If the license level is sufficient, it
 * returns `undefined`.
 */
const usePrebuiltRuleCustomizationUpsellingMessage = messageId => {
  // Upselling message is returned when the license level is insufficient,
  // otherwise it's undefined
  return (0, _use_upselling.useUpsellingMessage)(messageId);
};
exports.usePrebuiltRuleCustomizationUpsellingMessage = usePrebuiltRuleCustomizationUpsellingMessage;