"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.usePerformUpgradeRules = void 0;
var _utils = require("../../../../common/components/utils");
var _kibana = require("../../../../common/lib/kibana");
var _use_perform_rules_upgrade_mutation = require("../../api/hooks/prebuilt_rules/use_perform_rules_upgrade_mutation");
var i18n = _interopRequireWildcard(require("./translations"));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const usePerformUpgradeRules = () => {
  const toasts = (0, _kibana.useToasts)();
  return (0, _use_perform_rules_upgrade_mutation.usePerformRulesUpgradeMutation)({
    onError: error => {
      (0, _utils.showErrorToast)({
        title: i18n.RULE_UPGRADE_FAILED,
        fullMessage: JSON.stringify(error, null, 2),
        toasts
      });
    },
    onSuccess: (result, vars) => {
      if (vars.dry_run) {
        // This is a preflight check, no need to show toast
        return;
      }
      const successToastMessage = getSuccessToastMessage(result);
      if (successToastMessage) {
        toasts.addSuccess(getSuccessToastMessage(result));
      }
      if (result.summary.failed > 0) {
        (0, _utils.showErrorToast)({
          title: i18n.UPGRADE_RULE_FAILED(result.summary.failed),
          fullMessage: JSON.stringify(result.errors, null, 2),
          toasts
        });
      }
    }
  });
};
exports.usePerformUpgradeRules = usePerformUpgradeRules;
const getSuccessToastMessage = result => {
  const toastMessage = [];
  const {
    summary: {
      succeeded,
      skipped
    }
  } = result;
  if (succeeded > 0) {
    toastMessage.push(i18n.UPGRADE_RULE_SUCCESS(succeeded));
  }
  if (skipped > 0) {
    toastMessage.push(i18n.UPGRADE_RULE_SKIPPED(skipped));
  }
  return toastMessage.join(' ');
};