"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.KqlQueryEdit = KqlQueryEdit;
var _react = _interopRequireWildcard(require("react"));
var _useToggle = _interopRequireDefault(require("react-use/lib/useToggle"));
var _css = require("@emotion/css");
var _eui = require("@elastic/eui");
var _schema = require("../../../../../../../rule_creation_ui/components/step_define_rule/schema");
var _shared_imports = require("../../../../../../../../shared_imports");
var _query_bar_field = require("../../../../../../../rule_creation_ui/components/query_bar_field");
var stepDefineRuleI18n = _interopRequireWildcard(require("../../../../../../../rule_creation_ui/components/step_define_rule/translations"));
var _use_rule_from_timeline = require("../../../../../../../../detections/hooks/use_rule_from_timeline");
var _use_get_saved_query = require("../../../../../../../common/use_get_saved_query");
var _use_diffable_rule_data_view = require("../hooks/use_diffable_rule_data_view");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761322521701505730/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/detection_engine/rule_management/components/rule_details/three_way_diff/final_edit/fields/kql_query/kql_query_edit.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function KqlQueryEdit({
  finalDiffableRule,
  setFieldValue
}) {
  const {
    dataView,
    isLoading
  } = (0, _use_diffable_rule_data_view.useDiffableRuleDataView)(finalDiffableRule);
  const [isTimelineSearchOpen, toggleIsTimelineSearchOpen] = (0, _useToggle.default)(false);
  const handleSetRuleFromTimeline = (0, _react.useCallback)(({
    queryBar: timelineQueryBar
  }) => {
    setFieldValue('queryBar', timelineQueryBar);
  }, [setFieldValue]);
  const {
    onOpenTimeline
  } = (0, _use_rule_from_timeline.useRuleFromTimeline)(handleSetRuleFromTimeline);
  const isSavedQueryRule = finalDiffableRule.type === 'saved_query';
  const {
    savedQuery
  } = (0, _use_get_saved_query.useGetSavedQuery)({
    savedQueryId: getSavedQueryId(finalDiffableRule),
    ruleType: finalDiffableRule.type
  });
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_shared_imports.UseField, {
    path: "ruleType",
    component: _shared_imports.HiddenField,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 49,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_shared_imports.UseField, {
    path: "queryBar",
    config: {
      // queryBar's validation doesn't work until specified here.
      // ...schema.queryBar copies all configuration from the define rule form schema.
      ..._schema.schema.queryBar,
      label: stepDefineRuleI18n.QUERY_BAR_LABEL,
      labelAppend: isSavedQueryRule ? null : /*#__PURE__*/_react.default.createElement(ImportTimelineQueryButton, {
        handleOpenTimelineSearch: toggleIsTimelineSearchOpen,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 58,
          columnNumber: 13
        }
      })
    },
    component: _query_bar_field.QueryBarField,
    componentProps: {
      indexPattern: dataView !== null && dataView !== void 0 ? dataView : DEFAULT_DATA_VIEW,
      isLoading,
      openTimelineSearch: isTimelineSearchOpen,
      onCloseTimelineSearch: toggleIsTimelineSearchOpen,
      onOpenTimeline,
      isDisabled: isSavedQueryRule,
      defaultSavedQuery: savedQuery,
      resetToSavedQuery: isSavedQueryRule,
      bubbleSubmitEvent: true
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 50,
      columnNumber: 7
    }
  }));
}
const DEFAULT_DATA_VIEW = {
  fields: [],
  title: ''
};
const timelineButtonClassName = (0, _css.css)`
  height: 18px;
  font-size: 12px;
`;
function ImportTimelineQueryButton({
  handleOpenTimelineSearch
}) {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    className: timelineButtonClassName,
    onClick: handleOpenTimelineSearch,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 94,
      columnNumber: 5
    }
  }, stepDefineRuleI18n.IMPORT_TIMELINE_QUERY);
}
function getSavedQueryId(diffableRule) {
  if (diffableRule.type === 'saved_query' && 'saved_query_id' in diffableRule.kql_query) {
    return diffableRule.kql_query.saved_query_id;
  }
  return undefined;
}